/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  pc16550hdl_create.c
 * @brief %jp{PC16550pn[hEFAANZXw}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "pc16550hal_local.h"


/* %jp{1M} */
int Pc16550Hal_SendChar(C_PC16550HAL *self, int c)
{
	if ( PC16550HAL_READ_LSR(self) & 0x20  )	
	{
		self->iTxFree = PC16550HAL_TXFIFO_SIZE;
	}

	/* M\`FbN */
	if ( self->iTxFree <= 0 )
	{
		return -1;
	}
	self->iTxFree--;
	
	PC16550HAL_WRITE_THR(self, c);

	return (unsigned char)c;
}


/* end of file */
