/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  scidrv_local.h
 * @brief %jp{Renesas H8/SHp SCIfoCXhCo}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__scidrv_local_h__
#define __HOS__scidrv_local_h__


#include "scidrv.h"
#include "system/file/syncdrv_local.h"
#include "system/sysapi/sysapi.h"
#include "library/container/streambuf/streambuf.h"
#include "scihal.h"


/* SCIphCo䕔 */
typedef struct c_scidrv
{
	C_SYNCDRV		SyncDrv;		/* @\tfoCXhCop */

	C_SCIHAL		SciHal;			/* n[hEFAۉNX */

	int				iOpenCount;		/* I[vJE^ */
	int				iIntNum;		/* ݔԍ */
	SYSISR_HANDLE	hIsrRxErr;		/* MG[݃T[rX[`nh */
	SYSISR_HANDLE	hIsrRx;			/* M݃T[rX[`nh */
	SYSISR_HANDLE	hIsrTx;			/* M݃T[rX[`nh */
	SYSISR_HANDLE	hIsrTxEnd;		/* M݃T[rX[`nh */
	
	C_STREAMBUF		StmBufRecv;		/* Mobt@ */
} C_SCIDRV;


#ifdef __cplusplus
extern "C" {
#endif

FILE_ERR  SciDrv_Constructor(C_SCIDRV *self, const T_DRVOBJ_METHODS *pMethods, void *pRegBase, int iIntNum, unsigned long ulSysClock, int iBufSize);	/**< RXgN^ */
void      SciDrv_Destructor(C_SCIDRV *self);																											/**< fXgN^ */

HANDLE    SciDrv_Open(C_DRVOBJ *pDrvObj, const char *pszPath, int iMode);
void      SciDrv_Close(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj);
FILE_ERR  SciDrv_IoControl(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, int iFunc, void *pInBuf, FILE_SIZE InSize, const void *pOutBuf, FILE_SIZE OutSize);
FILE_POS  SciDrv_Seek(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, FILE_POS Offset, int iOrign);
FILE_SIZE SciDrv_Read(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, void *pBuf, FILE_SIZE Size);
FILE_SIZE SciDrv_Write(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, const void *pData, FILE_SIZE Size);
FILE_ERR  SciDrv_Flush(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj);

void      SciDrv_IsrRxErr(VPARAM Param);	/* MG[ */
void      SciDrv_IsrRx(VPARAM Param);		/* M */
void      SciDrv_IsrTx(VPARAM Param);		/* MGveB[ */
void      SciDrv_IsrTxEnd(VPARAM Param);	/* MI */

#ifdef __cplusplus
}
#endif


#endif	/* __HOS__scidrv_local_h__ */


/* end of file */
