/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  ipether.h
 * @brief %jp{EtherIPvgR(܂MACwߕ)}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <string.h>
#include "ipether_local.h"


/** RXgN^ */
FILE_ERR IpEther_Constructor(C_IPETHER *self, const T_DRVOBJ_METHODS *pMethods, const char *pszEther, const T_IPETHER_INF *pInf)
{
	/* Ether|[gI[v */
	self->hEther = File_Open(pszEther, FILE_OPEN_READ | FILE_OPEN_WRITE | FILE_OPEN_EXIST);
	if ( self->hEther == HANDLE_NULL )
	{
		return FILE_ERR_NG;
	}
	
	/* eNXRXgN^Ăяo */
	SyncDrv_Constructor(&self->SyncDrv, pMethods, SYNCDRV_FACTOR_NUM);
	
	/* oϐ */
	self->iOpenCount = 0;
	self->iRecvHead  = 0;
	self->iRecvNum   = 0;
	
	memcpy(self->ubMyIpAddr,      pInf->ubIpAddr, 4);
	memcpy(self->ubSubNetMask,    pInf->ubSubNetMask, 4);
	memcpy(self->ubGateWayIpAddr, pInf->ubGateWayIpAddr, 4);
	
	/* Cxg */
	self->hEvtRecv = SysEvt_Create(SYSEVT_ATTR_AUTOCLEAR);
	self->hEvtArp  = SysEvt_Create(SYSEVT_ATTR_AUTOCLEAR);

	/* ~[ebNX */
	self->hMtxSend = SysMtx_Create(SYSMTX_ATTR_NORMAL);
	self->hMtxRecv = SysMtx_Create(SYSMTX_ATTR_NORMAL);
	self->hMtxArp  = SysMtx_Create(SYSMTX_ATTR_NORMAL);

	/* MvZX */
	self->hPrcRecv = SysPrc_Create(IpEther_Recv, (VPARAM)self, NULL, 1024, 2, SYSPRC_ATTR_NORMAL);
	SysPrc_Start(self->hPrcRecv);
	
	return FILE_ERR_OK;
}


/* endof file */
