/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  ipether.h
 * @brief %jp{EtherIPvgR(܂MACwߕ)}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <string.h>
#include "ipether_local.h"


/* IPpPbgM */
FILE_SIZE IpEther_Read(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, void *pBuf, FILE_SIZE Size)
{
	C_IPETHER	*self;
	int			iRecvSize;
	
	/* upper cast */
	self = (C_IPETHER *)pDrvObj;
	
	/* M҂ */
	while ( self->iRecvNum <= 0 )
	{
		SysEvt_Wait(self->hEvtRecv);
		SysEvt_Clear(self->hEvtRecv);
	}
	
	iRecvSize = self->ubRecvBuf[self->iRecvHead][0] * 256 + self->ubRecvBuf[self->iRecvHead][1];
	if ( Size < iRecvSize )
	{
		iRecvSize = Size;
	}
	
	/* f[^Rs[ */
	memcpy(pBuf, &self->ubRecvBuf[self->iRecvHead][14], iRecvSize);
	
	/* O|C^i߂ */
	SysMtx_Lock(self->hMtxRecv);
	self->iRecvNum--;
	if ( self->iRecvHead >= IPETHER_RECVBUS_SIZE - 1 )
	{
		self->iRecvHead = 0;
	}
	else
	{
		self->iRecvHead++;
	}
	SysMtx_Unlock(self->hMtxRecv);
	
	return iRecvSize;
}



/* endof file */
