/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  fatvol.c
 * @brief %jp{FAT{[pfoCXhCo}
 *
 * Copyright (C) 2006-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "fatvol_local.h"


#include "hosaplfw.h"


/** NX^ */
int FatVol_ClusterWrite(
		C_FATVOL    *self,
		FATVOL_UINT uiCluster,
		const void  *pBuf)
{
	FATVOL_UINT uiPos;
	FATVOL_UINT uiSize;
	
/*	StdIo_PrintFormat("[FatLol] write cluster %08x\n", uiCluster);	*/
	
	
	if ( uiCluster >= 0x0f000000 && (self->iFatType == FATVOL_TYPE_FAT12 || self->iFatType == FATVOL_TYPE_FAT16) )
	{
		/* FAT12/16 ̃[gfBNg 0x0f000000 Ƀ}bv */
		uiCluster -= 0x0f000000;
		
		/* oʒuړ */
		uiPos = (self->RootDirSector + (uiCluster * self->SectorsPerCluster)) * self->BytesPerSector + self->Offset;
		if ( File_Seek(self->hBlockFile, uiPos, FILE_SEEK_SET) != uiPos )
		{
			return FATVOL_ERR_NG;
		}
		
		/* o */
		uiSize = self->BytesPerSector * self->SectorsPerCluster;
		if ( File_Write(self->hBlockFile, pBuf, (FILE_SIZE)uiSize) != uiSize )
		{
			return FATVOL_ERR_NG;
		}
	}
	else
	{
		/* oʒuړ */
		uiPos = (self->Cluster0Sector + (uiCluster * self->SectorsPerCluster)) * self->BytesPerSector + self->Offset;
		if ( File_Seek(self->hBlockFile, uiPos, FILE_SEEK_SET) != uiPos )
		{
			return FATVOL_ERR_NG;
		}
		
		/* o */
		uiSize = self->BytesPerSector * self->SectorsPerCluster;
		if ( File_Write(self->hBlockFile, pBuf, (FILE_SIZE)uiSize) != uiSize )
		{
			return FATVOL_ERR_NG;
		}
	}
	
	return FATVOL_ERR_OK;
}


/* end of file */
