/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  fatvol.c
 * @brief %jp{FAT{[pfoCXhCo}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include <string.h>
#include "fatvol_local.h"


/** %jp{Ǐo} */
FILE_SIZE FatVol_Read(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, void *pBuf, FILE_SIZE Size)
{
	C_FATVOL		*self;
	C_FATFILE		*pFile;
	FILE_SIZE		ReqSize;
	unsigned char	*pubBuf;
	FATVOL_UINT		uiCluster;
	FATVOL_UINT		i;
	
	/* upper cast */
	self  = (C_FATVOL *)pDrvObj;
	pFile = (C_FATFILE *)pFileObj;
	
	pubBuf = (unsigned char *)pBuf;


	/* NeBJZNVɓ */
	SysMtx_Lock(self->hMtx);
	
	/* TCY`FbN */
	if ( !(FileObj_GetMode(&pFile->FileObj) & FILE_OPEN_DIR) )
	{
		if ( Size > pFile->FileSize - pFile->FilePos )
		{
			/* TCYXVĂȂfBNge[uQƂׂH */

			/* TCYNbv */
			Size = (FILE_SIZE)(pFile->FileSize - pFile->FilePos);
		}
	}
	
	/* vǂݏoʕۑ */
	ReqSize = Size;
	
	/* NX^ */
	uiCluster = pFile->uiStartCluster;
	for ( i = 0; pFile->FilePos >= (FILE_POS)((i + 1) * self->BytesPerCluster); i++ )
	{
		uiCluster = FatVol_GetNextCluster(self, uiCluster);
	}
	
	/* ǂݏo */
	while ( Size > 0 && (pFile->FilePos < pFile->FileSize || (FileObj_GetMode(&pFile->FileObj) & FILE_OPEN_DIR)) )
	{
		FILE_POS 			ReadStart;
		FILE_SIZE			ReadSize;
		T_FATVOL_CLUSTERBUF *pClusterBuf;
		
		/* NX^`FbN */
		if ( uiCluster == FATVOL_CLUSTER_ENDMARKER )
		{
			break;
		}
		
		/* ]ʒuvZ */
		ReadStart = (pFile->FilePos & (self->BytesPerCluster) - 1);
		ReadSize  = (FILE_SIZE)(self->BytesPerCluster - ReadStart);
		if ( ReadSize > Size )
		{
			ReadSize     = Size;
		}
		
		/* obt@擾 */
		if ( (pClusterBuf = FatVol_GetClusterBuf(self, uiCluster, 1)) == NULL )
		{
			break;
		}

		/* ] */
		memcpy(pubBuf, &pClusterBuf->pubBuf[ReadStart], ReadSize);

		/* obt@J */
		FatVol_RelClusterBuf(self, pClusterBuf, 0);
		
		/* TCYXV */
		pFile->FilePos += ReadSize;
		pubBuf         += ReadSize;
		Size           -= ReadSize;
		
		/* ̃NX^ɐi */
		uiCluster = FatVol_GetNextCluster(self, uiCluster);
		
		/* UbN */
		SysMtx_Unlock(self->hMtx);
		SysMtx_Lock(self->hMtx);
	}
	
	/* NeBJZNVo */
	SysMtx_Unlock(self->hMtx);
	
	return ReqSize - Size;
}


/* end of file */
