/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  stringformat.c
 * @brief %jp{tH[}bgCu}
 *
 * Copyright (C) 2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "stringformat_local.h"



/* tt10io */
int StringFormat_Decimal(int (*pfncPut)(int c, void *Param), void *Param, long lNum, int iSigned, int iWidth, int iPadChar, int iFlag)
{
	unsigned long	ulNum;
	char			szBuf[10];
	int  			iLen = 0;
	int  			iSignChar;
	int				iPadSize;
	int  			iSign;
	int  			iSize;
	
	/* `FbN */
	if ( lNum < 0 && iSigned )
	{
		ulNum = -lNum;
		iSign = 1;
		iSignChar = '-';
	}
	else
	{
		ulNum = lNum;
		iSign = (iFlag == '+') ? 1 : 0;
		iSignChar = '+';
	}
	
	/* ϊ */
	iSize = 0;
	do
	{
		szBuf[iSize++] = (char)((ulNum % 10) + '0');
		ulNum         /= 10;
	} while ( ulNum != 0 );
	
	/* peBOTCY */
	iPadSize = iWidth - iSize - iSign;
	
	/* lΐɃpfBO */
	if ( iFlag != '-' )
	{
		while ( iWidth > iSize + iSign )
		{
			iWidth--;
			if ( pfncPut(iPadChar, Param) <= 0 )
			{
				return iLen;
			}
			iLen++;
		}
	}
	
	/* o */
	if ( iSign )
	{
		if ( pfncPut(iSignChar, Param) <= 0 )
		{
			return iLen;
		}
		iLen++;
	}
	
	/* lo */
	do
	{
		 if ( pfncPut(szBuf[--iSize], Param) <= 0 )
		{
			return iLen;
		}
		iLen++;
	} while ( iSize > 0);
		
	/* lȂpfBO */
	if ( iFlag == '-' )
	{
		while ( iPadSize > 0 )
		{
			if ( pfncPut(' ', Param) <= 0 )
			{
				return iLen;
			}
			iLen++;

			iPadSize--;
		}
	}
	
	return iLen;
}


/* end of file */
