/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  stringformat.c
 * @brief %jp{tH[}bgCu}
 *
 * Copyright (C) 2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <string.h>
#include "stringformat_local.h"



/* o */
int StringFormat_String(int (*pfncPut)(int c, void *Param), void *Param, const char *pszStr, int iWidth, int iFlag)
{
	int	iLen = 0;
	int	iSize = 0;
	int	iPadSize;
	
	/* Œ\ɕKvȃTCYZo */
	iSize = strlen(pszStr);
	
	/* peBOTCY */
	iPadSize = iWidth - iSize;
	
	/* lΐɃpfBO */
	if ( iFlag != '-' )
	{
		while ( iPadSize > 0 )
		{
			if ( pfncPut(' ', Param) <= 0 )
			{
				return iLen;
			}
			iLen++;

			iPadSize--;
		}
	}
	
	/* o */
	while ( iSize > 0 )
	{
		if ( pfncPut(*pszStr++, Param) <= 0 )
		{
			return iLen;
		}
		iLen++;
	
		iSize--;
	}
	
	
	/* lȂpfBO */
	if ( iFlag == '-' )
	{
		while ( iPadSize > 0 )
		{
			if ( pfncPut(' ', Param) <= 0 )
			{
				return iLen;
			}
			iLen++;

			iPadSize--;
		}
	}
	
	return iLen;
}


/* end of file */
