/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  assoc.h
 * @brief %jp{AzzNX}
 *
 * Copyright (C) 2006-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__assoc_h__
#define __HOS__assoc_h__


#include "library/container/memheap/memheap.h"


#define ASSOC_ERR_OK		0
#define ASSOC_ERR_NG		(-1)
#define ASSOC_POS_NULL		(0)

typedef void*	ASSOC_POS;
typedef int     ASSOC_ERR;


/** m[hi[p\ */
typedef struct t_assoc_node
{
	struct t_assoc_node	*pLeft;
	struct t_assoc_node	*pRight;
	struct t_assoc_node	*pParent;
} T_ASSOC_NODE;


/** AzzNX */
typedef struct c_assoc
{
	T_ASSOC_NODE	*pRoot;
	C_MEMHEAP		*pMemHeap;
} C_ASSOC;



#ifdef __cplusplus
extern "C" {
#endif

/* ^폜 */
C_ASSOC	   *Assoc_Create(void);																/* Azobt@̐ */
C_ASSOC	   *Assoc_CreateEx(C_MEMHEAP *pMemHeap);											/* Azobt@̐ */
void        Assoc_Delete(C_ASSOC *self);													/* Azobt@̍폜 */
void        Assoc_Constructor(C_ASSOC *self, C_MEMHEAP *pMemHeap);							/* Azobt@̃RXgN^ */
void        Assoc_Destructor(C_ASSOC *self);												/* Azobt@̃fXgN^ */

/*  */
ASSOC_ERR   Assoc_Add(C_ASSOC *self, const char *pszKey, const void *pData, long lSize);	/* f[^̒ǉ */
ASSOC_ERR   Assoc_Set(C_ASSOC *self, const char *pszKey, const void *pData, long lSize);	/* f[^̐ݒ */
const void *Assoc_Get(C_ASSOC *self, const char *pszKey);									/* f[^̎Q */
ASSOC_ERR   Assoc_Remove(C_ASSOC *self, const char *pszKey);								/* f[^̍폜 */

/* Ce[^ */
ASSOC_POS   Assoc_GetFirst(C_ASSOC *self);
ASSOC_POS   Assoc_GetPos(C_ASSOC *self, const char *pszKey);
ASSOC_POS   Assoc_GetNext(C_ASSOC *self, ASSOC_POS *Pos);
const void *Assoc_GetAt(C_ASSOC *self, ASSOC_POS *Pos, const char **ppszKey);

#ifdef __cplusplus
}
#endif



#endif	/* __HOS__assoc_h__ */


/* end of file */
