/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  automemheap_local.h
 * @brief %jp{q[vNX}%en{auto size memory heap class}
 *
 * Copyright (C) 2006-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#ifndef __HOS__automemheap_local_h__
#define __HOS__automemheap_local_h__


#include "library/container/memheap/memheap_local.h"
#include "library/container/valmemheap/valmemheap_local.h"
#include "library/container/fixmemheap/fixmemheap_local.h"


typedef struct t_automemheap_fix
{
	struct t_automemheap_fix	*pNext;
	C_FIXMEMHEAP				FixMemHeap;
} T_AUTOMEMHEAP_FIX;

typedef struct t_automemheap_val
{
	struct t_automemheap_val	*pNext;
	C_VALMEMHEAP				ValMemHeap;
} T_AUTOMEMHEAP_VAL;

typedef struct t_automemheap_mem
{
	struct t_automemheap_mem	*pNext;
} T_AUTOMEMHEAP_MEM;


/** %jp{AutoMemHeapNX}%en{AutoMemHeap class} */
typedef struct c_automemheap
{
	C_MEMHEAP			MemHeap;		/**< p */

	C_MEMHEAP			*pMemHeap;		/**< q[v */
	
	T_AUTOMEMHEAP_FIX	*pFixList;		/**< ubNpŒTCYq[vXg */
	T_AUTOMEMHEAP_VAL	*pValList;		/**< ubNpσTCYq[vXg */
	T_AUTOMEMHEAP_MEM	*pMemList;		/**< ubNpXg */
	
	MEMSIZE				FixSize;		/**< ubN臒l */
	MEMSIZE				FixNum;			/**< ubN */
	MEMSIZE				ValSize;		/**< ubN臒l */
	
	int					iFixMax;
	int					iValMax;
} C_AUTOMEMHEAP;


#ifdef __cplusplus
extern "C" {
#endif

void       AutoMemHeap_Constructor(C_AUTOMEMHEAP *self, C_MEMHEAP *pMemHeap);	/**< RXgN^ */
void       AutoMemHeap_Destructor(C_AUTOMEMHEAP *self);							/**< fXgN^ */

void	  *AutoMemHeap_Alloc(void *pMemHeap, MEMSIZE Size);						/**< ̊蓖 */
void	  *AutoMemHeap_ReAlloc(void *pMemHeap, void *pMem, MEMSIZE Size);		/**< ̍Ċ蓖 */
void	   AutoMemHeap_Free(void *pMemHeap, void *pMem);						/**< ̊J */
MEMSIZE	   AutoMemHeap_GetSize(void *pMemHeap, void *pMem);						/**< ̃TCY擾 */
MEMSIZE	   AutoMemHeap_GetAlign(void *pMemHeap);								/**< ACg̎擾 */
MEMSIZE	   AutoMemHeap_AlignSize(void *pMemHeap, MEMSIZE Size);					/**< TCYACgPʂɊg */
int        AutoMemHeap_IsMember(void *pMemHeap, void *pMem);					/**< TCYACgPʂɊg */

C_MEMHEAP *AutoMemHeap_SearchHeap(C_AUTOMEMHEAP *self, void *pMem);				/**< q[v */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS__automemheap_local_h__ */


/* end of file */
