/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  fixmemheap_alloc.c
 * @brief %jp{ŒTCYq[vNX}%en{fixed size memory heap class}
 *
 * Copyright (C) 2006-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <stdio.h>
#include "fixmemheap_local.h"



/** %jp{̊蓖} */
void *FixMemHeap_Alloc(void *pMemHeap, MEMSIZE Size)
{
	C_FIXMEMHEAP	*self;
	void			*pMem;
	
	/* upper cast */
	self = (C_FIXMEMHEAP *)pMemHeap;
	
	/* %jp{q[v̑݃`FbN} */
	if ( self->pMemBase == NULL )
	{
		return NULL;
	}
	
	/* TCY`FbN */	
	if ( Size > self->BlkSize )
	{
		return NULL;
	}
	
	/* %jp{󂫃`FbN} */
	if ( self->ppFree == NULL )
	{
		return NULL;		
	}
	
	/* Xgqς */
	pMem = self->ppFree;
	self->ppFree = *self->ppFree;
	
	return pMem;
}

/* end of file */
