/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  hashtable_findfirst.c
 * @brief %jp{nbVe[uNX}%en{hash table class}
 *
 * Copyright (C) 2006-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <stdio.h>
#include <string.h>
#include "hashtable_local.h"


/** %jp{擾}%en{find next} */
const void *Hashtable_FindNext(C_HASHTABLE *self, T_HASHTABLE_ITERATOR *pIterator, const char **ppszKey)
{
	T_HASHTABLE_NODE	*pNode;
	int					iIndex;
	const char			*pszKey;
	const void			*pData;
	
	if ( pIterator == NULL )
	{
		return NULL;
	}
	
	/* T */
	pNode  = pIterator->pNode;
	iIndex = pIterator->iIndex;
	
	if ( pNode != NULL )
	{
		/* XgO */
		if ( pIterator->pNext == pIterator )
		{
			pNode->pIterator = NULL;
		}
		else
		{
			pIterator->pNext->pPrev = pIterator->pPrev;
			pIterator->pPrev->pNext = pIterator->pNext;
			if ( pNode->pIterator == pIterator )
			{
				pNode->pIterator = pIterator->pNext;
			}
		}
		
		/* ΐi */
		if ( (pNode = pNode->pNext) == NULL )
		{
			iIndex++;	/* Ύ̍ */
		}
	}
	
	if ( pNode == NULL )
	{
		for ( iIndex = pIterator->iIndex; iIndex < self->iTableSize; iIndex++ )
		{
			if ( (pNode = self->ppTable[iIndex]) != NULL )
			{
				break;
			}
		}
	}

	pIterator->pNode  = pNode;
	pIterator->iIndex = iIndex;

	if ( pNode == NULL )
	{
		*ppszKey = NULL;
		return NULL;
	}
	
	/* Xgڑ */
	if ( pNode->pIterator == NULL )
	{
		pNode->pIterator = pIterator;
		pIterator->pNext = pIterator;
		pIterator->pPrev = pIterator;
	}
	else
	{
		pIterator->pNext = pNode->pIterator;
		pIterator->pPrev = pIterator->pNext->pPrev;
		pIterator->pNext->pPrev = pIterator;
		pIterator->pPrev->pNext = pIterator;
	}
	
	/* f[^o */
	pszKey = (const char *)pNode + sizeof(T_HASHTABLE_NODE);
	pData  = (const void *)(pszKey + MemHeap_AlignSize(self->pMemHeap, strlen(pszKey)));
	
	/* f[^Ԃ */
	*ppszKey = pszKey;
	return pData;
}


/* end of file */
