/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  hashtable_get.c
 * @brief %jp{nbVe[uNX}%en{hash table class}
 *
 * Copyright (C) 2006-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <stdio.h>
#include <string.h>
#include "hashtable_local.h"


/* f[^̐ݒ */
HASHTABLE_ERR HashTable_Set(C_HASHTABLE *self, const char *pszKey, const void *pData, MEMSIZE Size)
{
	T_HASHTABLE_NODE		*pNode;
	T_HASHTABLE_NODE		*pNodeOld;
	T_HASHTABLE_NODE		*pNodePrev;
	T_HASHTABLE_ITERATOR	*pIterator;
	int						iIndex;
	
	/* m[h */
	if ( (pNode = HashTable_CreateNode(self, pszKey, pData, Size)) == NULL )
	{
		return HASHTABLE_ERR_NG;
	}

	/* ɖT */
	pNodeOld = HashTable_SearchNode(self, pszKey, &pNodePrev, &iIndex);
	
	/* ɂ΍XV */
	if ( pNodeOld != NULL )
	{
		/* wĂCe[^Εtւ */
		if ( (pIterator = pNodeOld->pIterator) != NULL )
		{
			pNode->pIterator = pIterator;
			do
			{
				pIterator->pNode = pNode;
				pIterator = pIterator->pNext;
			} while ( pIterator != pNodeOld->pIterator );
		}
		
		/* XgO */
		if ( pNodePrev != NULL )
		{
			pNodePrev->pNext = pNodeOld->pNext;
		}
		{
			self->ppTable[iIndex] = pNodeOld->pNext;
		}

		/* 폜 */
		HashTable_DeleteNode(self, pNodeOld);
	}
	else
	{
		self->iDataNum++;
	}
	
	/* Vm[hݒ */
	pNode->pNext          = self->ppTable[iIndex];
	self->ppTable[iIndex] = pNode;
	
	return HASHTABLE_ERR_OK;
}


/* end of file */
