/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  packetbuf.h
 * @brief %jp{pPbgf[^pobt@NX}
 *
 * Copyright (C) 2002-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "packetbuf_local.h"



/** Mpobt@̎擾(ȃRs[) */
unsigned int PacketBuf_GetBuf(C_PACKETBUF *self, void **ppBuf, unsigned int uiSize)
{
	unsigned int uiAllocSize;
	
	/* 蓖ăTCYvZ */
	uiAllocSize = PACKETBUF_DATASIZE(uiSize) + sizeof(unsigned int);
	
	/* 蓖ĉ\`FbN */
	if ( self->uiTail >= self->uiHead )
	{
		if ( self->uiTail > self->uiBufSize - uiAllocSize )
		{
			/* ܂Ԃ\`FbN */
			if ( self->uiHead <= uiAllocSize )
			{
				return 0;	/* 蓖ĕs */
			}
			
			/* ܂Ԃ */
			self->uiReturnPoint = self->uiTail;
			self->uiTail        = 0;
		}
	}
	else
	{
		if ( self->uiHead - self->uiTail <= uiAllocSize )
		{
			return 0;	/* 蓖ĕs */
		}
	}
	
	/* 蓖Ăobt@Ԃ */
	*ppBuf = (void *)(self->pubBuf + self->uiTail + sizeof(unsigned int));
	
	return uiSize;	/* 蓖ĂTCYԂ */
}


/* end of file */
