/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  streambuf.h
 * @brief %jp{Xg[f[^pobt@NX}
 *
 * Copyright (C) 2002-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__streambuf_h__
#define __HOS__streambuf_h__


/* Xg[obt@NX */
typedef struct c_streambuf
{
	unsigned char			*pubBuf;	/**< obt@̈̐擪AhX */
	unsigned int			uiBufSize;	/**< obt@̈̃TCY */
	volatile unsigned int	uiHead;		/**< f[^̐擪 */
	volatile unsigned int	uiTail;		/**< f[^̖ */
} C_STREAMBUF;


#ifdef __cplusplus
extern "C" {
#endif

/* ^폜 */
void         StreamBuf_Create(C_STREAMBUF *self, unsigned int uiBufSize, void *pBuf);		/**< RXgN^ */
#define      StreamBuf_Delete(self)	do {} while(0)											/**< fXgN^ */

/* f[^M */
unsigned int StreamBuf_SendData(C_STREAMBUF *self, const void *pData, unsigned int uiSize);	/**< f[^̑M */
unsigned int StreamBuf_GetBuf(C_STREAMBUF *self, void **ppBuf);								/**< Mpobt@̎擾(ȃRs[) */
void         StreamBuf_SendBuf(C_STREAMBUF *self, unsigned int uiSize);						/**< obt@̃f[^̑M(ȃRs[) */
int          StreamBuf_SendChar(C_STREAMBUF *self, int c);									/**< PLN^̑M */

/* f[^M */
unsigned int StreamBuf_RecvData(C_STREAMBUF *self, void *pBuf, unsigned int uiSize);		/**< f[^̎M */
unsigned int StreamBuf_RecvBuf(C_STREAMBUF *self, void **ppBuf);							/**< Mf[^̓obt@̎擾(ȃRs[) */
void         StreamBuf_RelBuf(C_STREAMBUF *self, unsigned int uiSize);						/**< Mpobt@̉(ȃRs[) */
int          StreamBuf_RecvChar(C_STREAMBUF *self);											/**< PLN^̎M */

/*  */
void         StreamBuf_Clear(C_STREAMBUF *self);											/**< obt@̃NA */
unsigned int StreamBuf_RefDataSize(C_STREAMBUF *self);										/**< obt@󂫗eʂ̎Q */
unsigned int StreamBuf_RefFreeSize(C_STREAMBUF *self);

#define      StreamBuf_RefMaxSize(self)		((self)->uiBufSize - 1)							/**< ői[\TCYQ */
#define      StreamBuf_RefBufAddr(self)		((void *)(self)->pubBuf)						/**< obt@AhX̎Q */
#define      StreamBuf_RefBufSize(self)		((self)->uiBufSize)								/**< obt@f[^ʂ̎Q */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS__streambuf_h__ */


/* end of file */
