/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  streambuf.h
 * @brief %jp{Xg[f[^pobt@NX}
 *
 * Copyright (C) 2002-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <string.h>
#include "streambuf_local.h"



/** f[^̎M */
unsigned int StreamBuf_RecvData(C_STREAMBUF *self, void *pBuf, unsigned int uiSize)
{
	void 			*pRecvBuf;			/* obt@AhX */
	unsigned int 	uiBufSize;			/* obt@TCY */
	unsigned int	uiRecvSize = 0;	/* MTCY */

	do
	{
		/* Mobt@擾 */
		if ( (uiBufSize = StreamBuf_RecvBuf(self, &pRecvBuf)) <= 0 )
		{
			break;
		}

		/* MTCYvZ */
		if ( uiBufSize > uiSize )
		{
			uiBufSize = uiSize;
		}

		/* M */
		memcpy(pBuf, pRecvBuf, uiBufSize);
		StreamBuf_RelBuf(self, uiBufSize);
		uiSize     -= uiBufSize;
		uiRecvSize += uiBufSize;
		pBuf        = (void *)((char *)pBuf + uiBufSize);
	} while ( uiSize > 0 );

	return uiRecvSize;
}


/* end of file */
