/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  valmemheap_alloc.c
 * @brief %jp{σTCYq[vNX}%en{variable size memory heap class}
 *
 * Copyright (C) 2006-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <stdio.h>
#include "valmemheap_local.h"



/** %jp{̊蓖} */
void *ValMemHeap_Alloc(void *pMemHeap, MEMSIZE Size)
{
	C_VALMEMHEAP		*self;
	T_VALMEMHEAP_MEMBLK	*mblk;
	T_VALMEMHEAP_MEMBLK	*mblk_next;
	T_VALMEMHEAP_MEMBLK	*mblk_next2;
	MEMSIZE				MemBlockSize;
	
	
	/* upper cast */
	self = (C_VALMEMHEAP *)pMemHeap;
	
	/* %jp{q[v̑݃`FbN} */
	if ( self->pMemBase == NULL )
	{
		return NULL;
	}
	
	/* %jp{TCỸACg𒲐} */
	Size = ValMemHeap_AlignSize(self, Size);
	
	/* %jp{ubÑTCY𒲐} */
	MemBlockSize = ValMemHeap_GetMemBlockSize(self);
	
	/* %jp{󂫗̈} */
	mblk = self->pMemBase;
	while ( mblk->Size != 0 )
	{
		if ( mblk->iFlag == VALMEMHEAP_FREE && mblk->Size >= Size )
		{
			/* \ȗeʂ */
			if ( mblk->Size - Size > MemBlockSize + (self->AlignMask + 1) )
			{
				/* ubN𕪊 */
				mblk_next  = (T_VALMEMHEAP_MEMBLK *)((char *)mblk + MemBlockSize + Size);
				mblk_next2 = (T_VALMEMHEAP_MEMBLK *)((char *)mblk + MemBlockSize + mblk->Size);
				mblk_next->pPrev  = mblk;
				mblk_next->Size   = mblk->Size - Size - MemBlockSize;
				mblk_next->iFlag  = VALMEMHEAP_FREE;
				mblk_next2->pPrev = mblk_next;
				mblk->Size        = Size;
			}
			mblk->iFlag = VALMEMHEAP_USING;
			
			return (void *)((char *)mblk + MemBlockSize);
		}
		
		/* ̃ubN֐i */
		mblk = (T_VALMEMHEAP_MEMBLK *)((char *)mblk + mblk->Size + MemBlockSize);
	}

	return NULL;	/* 󂫂 */
}

/* end of file */
