/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  valmemheap_free.c
 * @brief %jp{σTCYq[vNX}%en{variable size memory heap class}
 *
 * Copyright (C) 2006-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <stdio.h>
#include "valmemheap_local.h"



/** ̃TCY擾 */
MEMSIZE	ValMemHeap_GetSize(void *pMemHeap, void *pMem)
{
	C_VALMEMHEAP		*self;
	T_VALMEMHEAP_MEMBLK *mblk;
	MEMSIZE				MemBlockSize;
	
	/* upper cast */
	self = (C_VALMEMHEAP *)pMemHeap;

	/* %jp{ubÑTCY𒲐} */
	MemBlockSize = ValMemHeap_GetMemBlockSize(self);

	/* %jp{|C^͈̓`FbN} */
	if ( pMem < (void *)self->pMemBase || pMem >= (void *)((char *)self->pMemBase + self->MemSize) )
	{
		return 0;	/* %jp{̃v[̏łȂ} */
	}
	
	/* %jp{ubNʒu擾} */
	mblk = (T_VALMEMHEAP_MEMBLK *)((char *)pMem - MemBlockSize);
	
	/* %jp{p[^[`FbN} */
	if ( mblk->iFlag != VALMEMHEAP_USING )	/* %jp{gpŖ} */
	{
		return 0;	/* %jp{蓖ĂȂ} */
	}
	
	/* %jp{TCYԂ} */
	return mblk->Size;
}


/* end of file */
