/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  valmemheap_local.h
 * @brief %jp{σTCYq[vNX}%en{variable size memory heap class}
 *
 * Copyright (C) 2006-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#ifndef __HOS__valmemheap_local_h__
#define __HOS__valmemheap_local_h__


#include "library/container/memheap/memheap_local.h"


#define VALMEMHEAP_USING		0x1234			/**< %jp{gp} */
#define VALMEMHEAP_FREE			0xabcd			/**< %jp{gp} */


/** %jp{q[vubN} */
typedef struct t_valmemheap_memblk
{
	struct t_valmemheap_memblk*	pPrev;			/**< %jp{ÕubN} */
	MEMSIZE						Size;			/**< %jp{ubÑTCY} */
	int							iFlag;			/**< %jp{gptO} */
} T_VALMEMHEAP_MEMBLK;


/** %jp{ValMemHeapNX}%en{ValMemHeap class} */
typedef struct c_valmemheap
{
	C_MEMHEAP			MemHeap;		/* p */
	
	T_VALMEMHEAP_MEMBLK	*pMemBase;		/**< %jp{擪ubÑAhX} */
	MEMSIZE				MemSize;		/**< %jp{TCY} */
	int					AlignMask;		/**< %jp{ACgTCY} */
} C_VALMEMHEAP;


#ifdef __cplusplus
extern "C" {
#endif

void	ValMemHeap_Constructor(C_VALMEMHEAP *self, void *pMemBase, MEMSIZE MemSize, int AlignSize);
#define ValMemHeap_Destructor(self)			do { } while (0)

void	*ValMemHeap_Alloc(void *pMemHeap, MEMSIZE Size);					/**< ̊蓖 */
void	*ValMemHeap_ReAlloc(void *pMemHeap, void *pMem, MEMSIZE Size);		/**< ̍Ċ蓖 */
void	ValMemHeap_Free(void *pMemHeap, void *pMem);						/**< ̊J */
MEMSIZE	ValMemHeap_GetSize(void *pMemHeap, void *pMem);						/**< ̃TCY擾 */
MEMSIZE	ValMemHeap_GetAlign(void *pMemHeap);								/**< ACg̎擾 */
MEMSIZE	ValMemHeap_AlignSize(void *pMemHeap, MEMSIZE Size);					/**< TCYACgPʂɊg */
int     ValMemHeap_IsMember(void *pMemHeap, void *pMem);					/**< q[vɑĂ邩`FbN */

#define ValMemHeap_GetMemBlockSize(self)	(ValMemHeap_AlignSize((self), sizeof(T_VALMEMHEAP_MEMBLK)))

#ifdef __cplusplus
}
#endif



#endif	/* __HOS__valmemheap_local_h__ */


/* end of file */
