/** 
 *  Sample program for Hyper Operating System V4 Advance
 *
 * @file  ostimer.c
 * @brief %jp{OS^C}}%en{OS timer}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "kernel.h"
#include "ostimer.h"


#define OSTIMER_TIMER_INHNO		24			/**< %jp{݃nhԍ} */


#define REG_TIM16_TSTR		((volatile UB *)0xffffff60)
#define REG_TIM16_TSNC		((volatile UB *)0xffffff61)
#define REG_TIM16_TMDR		((volatile UB *)0xffffff62)
#define REG_TIM16_TOLR		((volatile UB *)0xffffff63)
#define REG_TIM16_TISRA		((volatile UB *)0xffffff64)
#define REG_TIM16_TISRB		((volatile UB *)0xffffff65)
#define REG_TIM16_TISRC		((volatile UB *)0xffffff66)

#define REG_TIM16_TCR0		((volatile UB *)0xffffff68)
#define REG_TIM16_TIOR0		((volatile UB *)0xffffff69)
#define REG_TIM16_TCNT0		((volatile UH *)0xffffff6a)
#define REG_TIM16_TCNT0H	((volatile UB *)0xffffff6a)
#define REG_TIM16_TCNT0L	((volatile UB *)0xffffff6b)
#define REG_TIM16_GRA0		((volatile UH *)0xffffff6c)
#define REG_TIM16_GRA0H		((volatile UB *)0xffffff6c)
#define REG_TIM16_GRA0L		((volatile UB *)0xffffff6d)
#define REG_TIM16_GRB0		((volatile UH *)0xffffff6e)
#define REG_TIM16_GRB0H		((volatile UB *)0xffffff6e)
#define REG_TIM16_GRB0L		((volatile UB *)0xffffff6f)


static void OsTimer_IrqHandler(VP_INT exinf);		/**< %jp{^C}݃nh} */


/** %jp{OSp^C}[`} */
void OsTimer_Initialize(VP_INT exinf)
{
#if 0
	T_DINH dfinh;
	
	/* %jp{݃nh`} */
	dfinh.inthdr = (FP)OsTimer_IrqHandler;
	def_inh(OSTIMER_TIMER_INHNO, &dfinh);
#else
	T_CISR cisr;
	cisr.isratr = TA_HLNG;
	cisr.intno  = OSTIMER_TIMER_INHNO;
	cisr.isr    = (FP)OsTimer_IrqHandler;
	cisr.exinf  = (VP_INT)'@';
	acre_isr(&cisr);
#endif

	/* %jp{^C}Jn} */
	*REG_TIM16_TSTR  &= ~0x01;		/* TCNT0~ */
	*REG_TIM16_TCR0   = 0x23;		/* /8ŃJEg, GRÃRyA}b`ŃNA */
	*REG_TIM16_TCNT0  = 0;			/* JE^NA */
	*REG_TIM16_GRA0   = 2500 - 1;	/* 10 msec ̃C^[oi20MHz/8 = 2.5MHzj */
	*REG_TIM16_TISRA &= ~0x01;		/* ݗvNA */
	*REG_TIM16_TISRA |= 0x10;		/* ݋ */
	*REG_TIM16_TSTR  |= 0x01;		/* TCNT0Jn */
}


/** %jp{^C}݃nh} */
void OsTimer_IrqHandler(VP_INT exinf)
{
	/* ݗvNA */
	*REG_TIM16_TISRA &= ~0x01;		/* ݗvNA */
	
	isig_tim();
}


/* end of file */
