/** 
 *  Sample program for Hyper Operating System V4 Advance
 *
 * @file  sample.c
 * @brief %jp{TvvO}%en{Sample program}
 *
 * Copyright (C) 1998-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "kernel.h"
#include "kernel_id.h"
#include "system/system/system.h"
#include "system/sysapi/sysapi.h"
#include "system/file/console.h"
#include "system/process/process.h"
#include "system/command/command.h"
#include "driver/serial/jelly/jellyuartdrv.h"
#include "driver/console/vt100/vt100drv.h"
#include "application//syscmd/shell/shell.h"
#include "application//syscmd/commandlist/commandlist.h"
#include "application//syscmd/processlist/processlist.h"
#include "application/utility/timecmd/timecmd.h"
#include "application/utility/memdump/memdump.h"
#include "application/utility/memwrite/memwrite.h"
#include "application/utility/memtest/memtest.h"
#include "application/utility/keytest/keytest.h"
#include "application/example/hello/hello.h"
#include "boot.h"
#include "ostimer.h"


#if 0

long	g_SystemHeap[128 * 1024 / sizeof(long)];
#define SYSTEM_HEAP_ADDR	((void *)g_SystemHeap)
#define SYSTEM_HEAP_SIZE	sizeof(g_SystemHeap)

#else

#define SYSTEM_HEAP_ADDR	((void *)0x00200000)
#define SYSTEM_HEAP_SIZE	0x00100000

#endif


extern SYSTIM_CPUTIME		SysTim_TimeCounter;		/* ftHg̃^C}JE^ */



int Boot_Process(VPARAM Param);


void Boot_Task(VP_INT exinf)
{
	T_SYSTEM_INITIALIZE_INF	SysInf;
	
	
	/*************************/
	/*                 */
	/*************************/
	
	/* VXe */
	memset(&SysInf, 0, sizeof(SysInf));
	SysInf.pSysMemBase     = SYSTEM_HEAP_ADDR;
	SysInf.SysMemSize      = SYSTEM_HEAP_SIZE;
	SysInf.SysMemAlign     = 8;
	SysInf.pIoMemBase      = NULL;
	SysInf.SystemStackSize = 2048;
	SysInf.pfncBoot        = Boot_Process;
	SysInf.BootParam       = (VPARAM)0;
	SysInf.BootStackSize   = 2048;
	System_Initialize(&SysInf);
}


/* u[gvZX */
int Boot_Process(VPARAM Param)
{
	T_PROCESS_CREATE_INF	ProcInf;
	HANDLE					hProcess;
	HANDLE					hDriver;
	HANDLE					hTty;
	HANDLE					hCon;
	
	
	/*************************/
	/*   foCXhCo    */
	/*************************/
	
	/* ^C} */	
	OsTimer_Initialize();
	
	/* Jelly UART foh (/dev/com0 ɓo^) */
	hDriver = JellyUartDrv_Create((void *)0xf2000000, 1, 2, 64);
	File_AddDevice("com0", hDriver);
	
	/* VAJ */
	hTty = File_Open("/dev/com0", FILE_OPEN_READ | FILE_OPEN_WRITE);
	
	/* VAɃR\[𐶐( /dev/con0 ɓo^) */
	hDriver = Vt100Drv_Create(hTty);
	File_AddDevice("con0", hDriver);
	
	/* R\[J */
	hCon = File_Open("/dev/con0", FILE_OPEN_READ | FILE_OPEN_WRITE);
	
	
	/*************************/
	/*     Wo͐ݒ    */
	/*************************/
	
	Process_SetTerminal(HANDLE_NULL, hTty);
	Process_SetConIn(HANDLE_NULL, hCon);
	Process_SetConOut(HANDLE_NULL, hCon);
	Process_SetStdIn(HANDLE_NULL, hCon);
	Process_SetStdOut(HANDLE_NULL, hCon);
	Process_SetStdErr(HANDLE_NULL, hCon);
	
	
	/*************************/
	/*     R}ho^      */
	/*************************/
	Command_AddCommand("sh",       Shell_Main);
	Command_AddCommand("ps",       ProcessList_Main);
	Command_AddCommand("help",     CommandList_Main);
	Command_AddCommand("time",     TimeCmd_Main);
	Command_AddCommand("memdump",  MemDump_Main);
	Command_AddCommand("memwrite", MemWrite_Main);
	Command_AddCommand("memtest",  MemTest_Main);
	Command_AddCommand("keytest",  KeyTest_Main);
	Command_AddCommand("hello",    Hello_Main);
	
	
	/*************************/
	/*    NbZ[W     */
	/*************************/
	StdIo_PutString(
			"\n\n"
			"================================================================\n"
			" Hyper Operating System  Application Framework\n"
			"\n"
			"                          Copyright (C) 1998-2008 by Project HOS\n"
			"                          http://sourceforge.jp/projects/hos/\n"
			"================================================================\n"
			"\n");
	
	
	/*************************/
	/*      VFN       */
	/*************************/
	
	/* vZX̐*/
	ProcInf.pszCommandLine = "sh -i";								/* sR}h */
	ProcInf.pszCurrentDir  = "";									/* NfBNg */
	ProcInf.pfncEntry      = NULL;									/* NAhX */
	ProcInf.Param          = 0;										/* [U[p[^ */
	ProcInf.StackSize      = 2048;									/* X^bNTCY */
	ProcInf.Priority       = PROCESS_PRIORITY_NORMAL;				/* vZXDx */
	ProcInf.hTerminal      = Process_GetTerminal(HANDLE_NULL);		/* ^[~i */
	ProcInf.hConIn         = Process_GetConIn(HANDLE_NULL);			/* R\[ */
	ProcInf.hConOut        = Process_GetConOut(HANDLE_NULL);		/* R\[o */
	ProcInf.hStdIn         = Process_GetStdIn(HANDLE_NULL);			/* W */
	ProcInf.hStdOut        = Process_GetStdOut(HANDLE_NULL);		/* Wo */
	ProcInf.hStdErr        = Process_GetStdErr(HANDLE_NULL);		/* WG[o */
	for ( ; ; )
	{
		hProcess = Process_CreateEx(&ProcInf);
		Process_WaitExit(hProcess);
		Process_Delete(hProcess);
	}
}


/* end of file */
