/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  file.h
 * @brief %jp{t@CVXe}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__file_h__
#define __HOS__file_h__


#include <stdarg.h>
#include "system/handle/handleobj.h"


#define FILE_MAX_PATH						128			/* pX̍ől */
#define FILE_MAX_NAME						13			/* O̍ől */


/* G[R[h` */
#define FILE_ERR_OK							0			/* I*/
#define FILE_ERR_NG							(-1)		/* G[ */
#define FILE_ERR_BUSY						(-2)		/* ̃vZXp(ubLO[hȊOŃ|[Os) */
#define FILE_ERR_BACKGROUND					(-3)		/* obNOEhŏt */
#define FILE_ERR_TIMEOUT					(-4)		/* ^CAEg */

/* 萔` */
#define FILE_EOF							(-1)

/* Open[h` */
#define FILE_OPEN_READ						0x0001		/* Ǎ݋ */
#define FILE_OPEN_WRITE						0x0002		/* ݋ */
#define FILE_OPEN_CREATE					0x0004		/* ɐVK쐬 */
#define FILE_OPEN_EXIST						0x0008		/* ݂Ȃ΃G[ */
#define FILE_OPEN_APPEND					0x0010		/* ݂Ȃ΃G[ */
#define FILE_OPEN_TEXT						0x0080		/* eLXg[h */
#define FILE_OPEN_SHARE_READ				0x0100		/* Ǎ݋L */
#define FILE_OPEN_SHARE_WRITE				0x0200		/* ݋L */
#define FILE_OPEN_DIR						0x0800		/* fBNgI[v */

/* V[N */
#define FILE_SEEK_SET						0
#define FILE_SEEK_CUR						1
#define FILE_SEEK_END						2


/* [h */
#define FILE_SYNCMODE_BLOCKING				0x00		/* ubLO[h */
#define FILE_SYNCMODE_POLING				0x01		/* |[O[h */
#define FILE_SYNCMODE_BACKGROUND			0x02		/* obNOEhs */

/* ʒm^Cv */
#define FILE_SYNCTYPE_NONE					0x00		/* ʒmȂ */
#define FILE_SYNCTYPE_EVENT					0x01		/* Cxgʒm */
#define FILE_SYNCTYPE_CALLBACK				0x02		/* R[obNʒm */


/* IoControl@\R[h() */
#define FILE_IOCTL_GETDEVINF				0x0000		/* foCX𓾂 */
#define FILE_IOCTL_SYNC						0x0001		/*  */
#define FILE_IOCTL_GETSIZE					0x0010		/* t@CTCY擾 */
#define FILE_IOCTL_GETREADSIZE				0x0010		/* ǂݍ݉\TCY(Mobt@̃f[^)擾 */
#define FILE_IOCTL_GETWRITESIZE				0x0011		/* ݉\TCY(Mobt@̋󂫃TCY)擾 */
#define FILE_IOCTL_GETREADBUF				0x0020		/* [hobt@擾(ȃRs[Read) */
#define FILE_IOCTL_RELREADBUF				0x0021		/* [hobt@ԋp(ȃRs[Read) */
#define FILE_IOCTL_GETWRITEBUF				0x0030		/* Cgobt@擾(ȃRs[Write) */
#define FILE_IOCTL_SENDWRITEBUF				0x0031		/* Cgobt@M(ȃRs[Write) */
#define FILE_IOCTL_CANWRITEBUF				0x0032		/* Cgobt@j(ȃRs[Write) */


/* IoControl@\R[h() */
#define FILE_IOCTL_SET_WRITE_SYNCMODE		0x0081		/* ݂̓[hݒ */
#define FILE_IOCTL_SET_READ_SYNCMODE		0x0082		/* Ǎ݂̓[hݒ */
#define FILE_IOCTL_SET_IOCTL_SYNCMODE		0x0083		/* I/O̓[hݒ */

#define FILE_IOCTL_SET_WRITE_SYNCINF		0x0091		/* ݂̓ݒ */
#define FILE_IOCTL_SET_READ_SYNCINF			0x0092		/* Ǎ݂̓ݒ */
#define FILE_IOCTL_SET_IOCTL_SYNCINF		0x0093		/* I/O̓ݒ */


/* IoControl@\R[h(fBNg) */
#define FILE_IOCTL_DIR_READ					0x0101		/* fBNg𓾂 */


/* IoControl@\R[h(R\[) */
#define FILE_IOCTL_CON_GETCH				0x0201		/* Ǎ */

/* IoControl@\R[h(VAʐM) */
#define FILE_IOCTL_COM_GETSPEED				0x2101		/* BPS擾 */
#define FILE_IOCTL_COM_SETSPEED				0x2101		/* BPSݒ */

/* IoControl@\R[h(Ether) */
#define FILE_IOCTL_ETHER_GETPHA				0x2201		/* AhX擾 */
#define FILE_IOCTL_ETHER_SETPHA				0x2202		/* AhXݒ */

/* IoControl@\R[h(IPw) */
#define FILE_IOCTL_IP_GETIP					0x2301		/* IPAhX擾 */
#define FILE_IOCTL_IP_SETIP					0x2302		/* IPAhXݒ */
#define FILE_IOCTL_IP_GETMASK				0x2303		/* IPTulbg}XN擾 */
#define FILE_IOCTL_IP_SETMASK				0x2304		/* IPTulbg}XNݒ */

#define FILE_IOCTL_IP_GETMASK				0x2303		/* IPTulbg}XN擾 */
#define FILE_IOCTL_IP_SETMASK				0x2304		/* IPTulbg}XNݒ */

/* IoControl@\R[h([U[`) */
#define FILE_IOCTL_USER						0x6000		/* 0x6000`0x7fff */


/* t@C */
#define FILE_ATTR_READONLY					0x01
#define FILE_ATTR_HIDDEN					0x02
#define FILE_ATTR_SYSTEM					0x04
#define FILE_ATTR_DIR						0x10
#define FILE_ATTR_ARCHIVE					0x20
#define FILE_ATTR_DEVICE					0x80


/* ^` */
typedef char			FILE_ATTR;						/* t@C */
typedef int				FILE_ERR;						/* t@C̃G[^ */
typedef _HOS_SINT64		FILE_POS;						/* t@Cʒǔ^` */
typedef long			FILE_SIZE;						/* ǂݏ̃TCYp̌^` */
typedef unsigned long	FILE_TIME;						/* ǂݏ̃TCYp̎^` */

struct c_drvobj;


/* t@C */
typedef struct t_file_fileinf
{
	char		szFileName[FILE_MAX_NAME];
	FILE_ATTR	Attribute;
	FILE_POS	FileSize;

/*
	FILE_TIME	timeCreate;
	FILE_TIME	timeAceess;
	FILE_TIME	timeWrite;
*/

	char		szInformation[64];
} T_FILE_FILEINF;


/*  */
typedef struct t_file_syncinf
{
	int			Type;
	union
	{
		struct
		{
			void	(*pfncProc)(VPARAM Param, FILE_ERR ErrCode);
			VPARAM	Param;
		} Proc;
		HANDLE hEvent;
	} Sync;
} T_FILE_SYNCINF;


#include "fileobj.h"
#include "drvobj.h"


#ifdef __cplusplus
extern "C" {
#endif

/* VXe */
void      File_Initialize(void);											/* t@CVXȅ */

FILE_ERR  File_AddDevice(const char *pszName, HANDLE hDriver);				/* foCXhCo̓o^ */
FILE_ERR  File_RemoveDevice(const char *pszName);							/* foCXhCo̍폜 */
HANDLE    File_GetDevice(const char *pszName);								/* foCXhCo̎擾 */

FILE_ERR  File_AddVolume(const char *pszName, HANDLE hVolume);				/* {[̃}Eg */
FILE_ERR  File_RemoveVolume(const char *pszName);							/* {[̃A}Eg */
HANDLE    File_GetVolume(const char *pszName);								/* {[̎擾 */


/* {API */
HANDLE    File_Open(const char *pszPath, int iMode);
void      File_Close(HANDLE hFile);
FILE_ERR  File_IoControl(HANDLE hFile, int iFunc, void *pInBuf, FILE_SIZE InSize, const void *pOutBuf, FILE_SIZE OutSize);
FILE_POS  File_Seek(HANDLE hFile, FILE_POS Offset, int iOrign);
FILE_SIZE File_Read(HANDLE hFile, void *pBuf, FILE_SIZE Size);
FILE_SIZE File_Write(HANDLE hFile, const void *pData, FILE_SIZE Size);
FILE_ERR  File_Flush(HANDLE hFile);

/* foCXhCoڐ */
HANDLE    File_DriverOpen(HANDLE hDriver, const char *pszPath, int iMode);				/* t@C̃I[v */
FILE_ERR  File_GetDriverInformation(HANDLE hDriver, char *pszInformation, int iLen);	/* foCXhCo擾 */


/* API */
FILE_ERR  File_SetWriteMode(HANDLE hFile, int iWriteMode);
FILE_ERR  File_GetWriteStatus(HANDLE hFile);
FILE_ERR  File_SetWriteEvent(HANDLE hFile, HANDLE hEvent);
FILE_ERR  File_SetReadMode(HANDLE hFile, int iReadMode);
FILE_ERR  File_GetReadStatus(HANDLE hFile);
FILE_ERR  File_SetReadEvent(HANDLE hFile, HANDLE hEvent);
FILE_ERR  File_SetIoMode(HANDLE hFile, int iReadMode);
FILE_ERR  File_GetIoStatus(HANDLE hFile);
FILE_ERR  File_SetIoEvent(HANDLE hFile, HANDLE hEvent);


/* pAPI */
int       File_GetChar(HANDLE hFile);
int       File_GetString(HANDLE hFile, char *pszString, int iSize);
int       File_PutChar(HANDLE hFile, int c);
int       File_PutString(HANDLE hFile, const char *pszString);

/* tpAPI */
int       File_PrintFormatV(HANDLE hFile, const char *pszFormat, va_list argptr);
int       File_PrintFormat(HANDLE hFile, const char *pszFormat, ...);

int       File_PrintHexNibble(HANDLE hFile, unsigned char c);							/* 4bit16io */

int       File_PrintFormatDecimal(HANDLE hFile, long lNum, int iWidth, int iPadChar);	/* t10io */
int       File_PrintFormatVL(HANDLE hFile, const char *pszFormat, va_list argptr);		/* to͌yʔ */


/* fBNgǂݏo */
FILE_ERR  File_ReadDir(HANDLE hFile, T_FILE_FILEINF *pFileInf);


/* g */
FILE_POS  File_GetFileSize(HANDLE hFile);
FILE_SIZE File_GetReadSize(HANDLE hFile);
FILE_SIZE File_GetWriteSize(HANDLE hFile);

FILE_SIZE File_GetReadBuf(HANDLE hFile, void **ppBuf);
FILE_SIZE File_RelReadBuf(HANDLE hFile, void *pBuf, FILE_SIZE Size);
FILE_SIZE File_GetWriteBuf(HANDLE hFile, void **ppBuf);
FILE_SIZE File_SendWriteBuf(HANDLE hFile, void *pBuf, FILE_SIZE Size);
FILE_ERR  File_CanWriteBuf(HANDLE hFile, void *pBuf);

/* fBNg */
HANDLE    File_OpenDir(const char *pszName);											/**< fBNgJ */
FILE_ERR  File_ReadDir(HANDLE hDir, T_FILE_FILEINF *pFileInf);							/**< fBNgt@C */
HANDLE    File_MakeDir(const char *pszName);											/**< TufBNg쐬 */
HANDLE    File_Remove(const char *pszName);												/**< t@C폜 */
FILE_ERR  File_RelPathToAbsPath(char *pszDstPath, const char *pszSrcPath, int iMaxLen);	/**< ΃pX΃pXɕϊ */


#ifdef __cplusplus
}
#endif


#endif	/* __HOS__file_h__ */


/* end of file */
