/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  file.c
 * @brief %jp{t@CVXe}
 *
 * Copyright (C) 2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <stdio.h>
#include <string.h>
#include "file_local.h"
#include "system/sysapi/sysapi.h"
#include "library/algorithm/stringformat/stringformat.h"



static int File_OutputPrintFormat(int c, void *Param);		/* CupR[obN֐ */



/* to(Xgn) */
int File_PrintFormatV(HANDLE hFile, const char *pszFormat, va_list argptr)
{
	return StringFormat_FormatV(File_OutputPrintFormat, (void *)hFile, pszFormat, argptr);
}


/* CupR[obN֐ */
int File_OutputPrintFormat(int c, void *Param)
{
	HANDLE hFile;
	
	hFile = (HANDLE)Param;
	
	/* ʂt@CVXeփ_CNg */
	if ( File_PutChar(hFile, c) == FILE_EOF )
	{
		return 0;
	}
	
	return 1;
}


/* end of file */
