/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  syncfile.h
 * @brief %jp{@\tfoCXhCopt@CfBXNv^}
 *
 * %jp{t@CfBXNv^Ƃċ@\NX}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "syncdrv_local.h"


/* I/O */
FILE_ERR SyncDrv_IoControl(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, int iFunc, void *pInBuf, FILE_SIZE InSize, const void *pOutBuf, FILE_SIZE OutSize)
{
	C_SYNCDRV	*self;
	C_SYNCFILE	*pFile;
	
	/* upper cast */
	self  = (C_SYNCDRV *)pDrvObj;
	pFile = (C_SYNCFILE *)pFileObj;

	switch ( iFunc )
	{
	case FILE_IOCTL_SET_WRITE_SYNCMODE:		/* ݂̓[hݒ */
		if ( SyncDrv_GetSyncFactorNum(self) > SYNCDRV_FACTOR_WRITE )
		{
			SyncFile_SetSyncMode(pFile, SYNCDRV_FACTOR_WRITE, *(int *)pOutBuf);
			return FILE_ERR_OK;
		}
		break;

	case FILE_IOCTL_SET_READ_SYNCMODE:		/* Ǎ݂̓[hݒ */
		if ( SyncDrv_GetSyncFactorNum(self) > SYNCDRV_FACTOR_READ )
		{
			SyncFile_SetSyncMode(pFile, SYNCDRV_FACTOR_READ, *(int *)pOutBuf);
			return FILE_ERR_OK;
		}
		break;

	case FILE_IOCTL_SET_IOCTL_SYNCMODE:		/* I/O̓[hݒ */
		if ( SyncDrv_GetSyncFactorNum(self) > SYNCDRV_FACTOR_IOCTL )
		{
			SyncFile_SetSyncMode(pFile, SYNCDRV_FACTOR_IOCTL, *(int *)pOutBuf);
			return FILE_ERR_OK;
		}
		break;


	case FILE_IOCTL_SET_WRITE_SYNCINF:		/* ݂̓ݒ */
		if ( SyncDrv_GetSyncFactorNum(self) > SYNCDRV_FACTOR_WRITE )
		{
			SyncFile_SetSyncInf(pFile, SYNCDRV_FACTOR_WRITE, *(T_FILE_SYNCINF *)pOutBuf);
			return FILE_ERR_OK;
		}
		break;

	case FILE_IOCTL_SET_READ_SYNCINF:		/* Ǎ݂̓ݒ */
		if ( SyncDrv_GetSyncFactorNum(self) > SYNCDRV_FACTOR_READ )
		{
			SyncFile_SetSyncInf(pFile, SYNCDRV_FACTOR_READ, *(T_FILE_SYNCINF *)pOutBuf);
			return FILE_ERR_OK;
		}
		break;

	case FILE_IOCTL_SET_IOCTL_SYNCINF:		/* I/O̓ݒ */
		if ( SyncDrv_GetSyncFactorNum(self) > SYNCDRV_FACTOR_IOCTL )
		{
			SyncFile_SetSyncInf(pFile, SYNCDRV_FACTOR_IOCTL, *(T_FILE_SYNCINF *)pOutBuf);
			return FILE_ERR_OK;
		}
		break;
	}
	
	
	return FILE_ERR_NG;
}


/* end of file */
