/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  syncfile.h
 * @brief %jp{@\tfoCXhCo{NX}
 *
 * %jp{t@CfBXNv^Ƃċ@\NX}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "hosaplfw.h"
#include "syncdrv_local.h"
#include "system/system/system.h"


/** ̊Jn */
FILE_ERR SyncDrv_StartProcess(C_SYNCDRV *self, C_SYNCFILE *pSyncFile, int iFuctor)
{
	SysMtx_Lock(self->hMtx);	/* NeBJZNVɓ */
	
	/* VOiNA */
	SyncFile_ClearSignal(pSyncFile, iFuctor);
	
	if ( self->ppBusyFile[iFuctor] == NULL )
	{
		/* NĂȂΏJn */
		self->ppBusyFile[iFuctor] = pSyncFile;
	}
	else
	{
		/* ubLO[hŖȂ甲 */
		if ( SyncFile_GetSyncMode(pSyncFile, iFuctor) != FILE_SYNCMODE_BLOCKING )
		{
			SysMtx_Unlock(self->hMtx);	/* NeBJZNVo */
			return FILE_ERR_BUSY;
		}
		
		/* 󂭂܂ő҂ */
		SysMtx_Unlock(self->hMtx);	/* NeBJZNVo */
		for ( ; ; )
		{
			/* VOi҂ */
			SyncFile_WaitSignal(pSyncFile, iFuctor);

			SysMtx_Lock(self->hMtx);	/* NeBJZNVɓ */
			if ( self->ppBusyFile[iFuctor] == NULL )
			{
				/* NĂȂΏJn */
				self->ppBusyFile[iFuctor] = pSyncFile;
				break;
			}
			SyncFile_ClearSignal(pSyncFile, iFuctor);
			SysMtx_Unlock(self->hMtx);	/* NeBJZNVo */		
		}
	}
	
	SysMtx_Unlock(self->hMtx);	/* NeBJZNVo */
	
	return FILE_ERR_OK;
}


/* end of file */
