/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  syncfile.h
 * @brief %jp{@\tfoCXhCopt@CfBXNv^}
 *
 * %jp{t@CfBXNv^Ƃċ@\NX}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__syncfile_local_h__
#define __HOS__syncfile_local_h__

#include "syncfile.h"
#include "system/file/fileobj_local.h"
#include "system/file/syncdrv_local.h"
#include "system/sysapi/sysapi.h"


/* IuWFNg */
typedef struct t_syncfile_syncobj
{
	int					Mode;			/**< [h */
	VPARAM				ErrCode;		/**< G[R[h */
	SYSEVT_HANDLE		hEvt;			/**< Cxg */
	T_FILE_SYNCINF		Inf;			/**<  */
} T_SYNCFILE_SYNCOBJ;


/* t@CuWFNg{NX` */
typedef struct c_syncfile
{
	C_FILEOBJ			FileObj;		/**< t@CIuWFNgp */
	
	struct c_syncfile	*pNext;			/**< CxgĎXgAp */
	struct c_syncfile	*pPrev;			/**< CxgĎXgAp */

	T_SYNCFILE_SYNCOBJ	*pSyncObj;		/**< IuWFNg */
} C_SYNCFILE;


#ifdef __cplusplus
extern "C" {
#endif

FILE_ERR SyncFile_Constructor(C_SYNCFILE *self, const T_FILEOBJ_METHODS *pMethods, struct c_syncdrv *pSyncDrv, int iMode);
void     SyncFile_Destructor(C_SYNCFILE *self);

void     SyncFile_SetSignal(C_SYNCFILE *self, int iFactor);															/**< VOĩZbg */
#define  SyncFile_ClearSignal(self, iFactor)		do { SysEvt_Clear((self)->pSyncObj[iFactor].hEvt); } while(0)	/**< VOĩNA */
#define  SyncFile_WaitSignal(self, iFactor)			do { SysEvt_Wait((self)->pSyncObj[iFactor].hEvt); } while(0)	/**< VOi҂ */
#define  SyncFile_RefSignal(self, iFactor)			(SysEvt_RefStatus((self)->pSyncObj[iFactor].hEvt))				/**< VOȉԎQ */

#define  SyncFile_SetSyncMode(self, iFactor, x)		do { ((self)->pSyncObj[iFactor].Mode) = (x); } while(0)			/**< [hݒ */
#define  SyncFile_GetSyncMode(self, iFactor)		((self)->pSyncObj[iFactor].Mode)								/**< [h擾 */

#define  SyncFile_SetSyncInf(self, iFactor, x)		do { ((self)->pSyncObj[iFactor].Inf) = (x); } while(0)			/**< ݒ */
#define  SyncFile_GetSyncInf(self, iFactor)			((self)->pSyncObj[iFactor].Inf)									/**< 擾 */

#define  SyncFile_SetErrCode(self, iFactor, x)		do { ((self)->pSyncObj[iFactor].ErrCode) = (x); } while(0)		/**< G[R[hݒ */
#define  SyncFile_GetErrCode(self, iFactor)			((self)->pSyncObj[iFactor].ErrCode)								/**< G[R[h擾 */

#ifdef __cplusplus
}
#endif


#endif	/* __HOS__syncfile_h__ */


/* end of file */
