/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  process.h
 * @brief %jp{vZXIuWFNg}
 *
 * Copyright (C) 2006-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__process_h__
#define __HOS__process_h__


#include "system/type/type.h"
#include "system/handle/handle.h"
#include "system/file/file.h"
#include "system/file/console.h"
#include "library/container/assoc/assoc.h"


/* (Ƃ肠KÂTSSƂ^ʖڂɂƂׂ̈ɂЂƂ܂) */
#define PROCESS_PRIORITY_IDLE		50
#define PROCESS_PRIORITY_LOW		40
#define PROCESS_PRIORITY_NORMAL		30
#define PROCESS_PRIORITY_HIGH		20
#define PROCESS_PRIORITY_REALTIME	10

#define PROCESS_SIGNAL_HUP			1
#define PROCESS_SIGNAL_KILL			9


#define PROCESS_ERR_OK				0
#define PROCESS_ERR_NG				(-1)

typedef int		PROCESS_ERR;


/* vZX */
typedef struct t_process_create_inf
{
	const char	*pszCommandLine;					/**< R}hC */
	const char	*pszCurrentDir;						/**< NfBNg */
	int			(*pfncEntry)(VPARAM Param);			/**< NAhX */
	VPARAM		Param;								/**< [U[p[^ */
	MEMSIZE		StackSize;							/**< X^bNTCY */
	int			Priority;							/**< vZXDx */
	HANDLE		hTerminal;							/**< ^[~i */
	HANDLE		hConIn;								/**< R\[ */
	HANDLE		hConOut;							/**< R\[o */
	HANDLE		hStdIn;								/**< W */
	HANDLE		hStdOut;							/**< Wo */
	HANDLE		hStdErr;							/**< WG[o */
} T_PROCESS_CREATE_INF;



#ifdef __cplusplus
extern "C" {
#endif

HANDLE        Process_Create(const char *pszCommand, MEMSIZE StackSize, int Priority);			/**< vZX */
HANDLE        Process_CreateEx(const T_PROCESS_CREATE_INF *pInf);								/**< vZX(ڍא) */
void          Process_Delete(HANDLE hProcess);													/**< vZX폜 */

HANDLE        Process_GetCurrentHandle(void);													/**< ݂̃vZXnh擾 */	
void          Process_Exit(int iExitCode);														/**< ݂̃vZXI */

int           Process_IsExit(HANDLE hProcess);													/**< vZX̏ImF */
int           Process_WaitExit(HANDLE hProcess);												/**< vZX̏I҂ */
int           Process_GetExitCode(HANDLE hProcess);												/**< vZX̏IR[h擾 */

void          Process_SetSignalProc(HANDLE hProcess, void (*pfncSignalProc)(int iSignal));		/**< vZXɃVOiMvV[Wo^ */
void          Process_SendSignal(HANDLE hProcess, int iSignal);									/**< vZXɃVOi𑗐M */

PROCESS_ERR   Process_EnterSystemMode(void);													/**< VXe[hɓ */
void          Process_LeaveSystemMode(void);													/**< VXe[ho */
int           Process_IsSystemMode(void);														/**< VXe[hǂ₢킹 */

const char    *Process_GetCommandLine(HANDLE hProcess);											/**< R}hC̎擾 */	
unsigned long Process_GetExecutionTime(HANDLE hProcess, unsigned long *pulNanosecond);			/**< sԂ̎擾 */	
HANDLE        Process_GetParentProcess(HANDLE hProcess);										/**< evZX̎擾 */

void          Process_SetParam(HANDLE hProcess, VPARAM Param);									/**< vZXŗL̐ݒ */
VPARAM        Process_GetParam(HANDLE hProcess);												/**< vZXŗL̎擾 */

void          Process_SetEnvString(HANDLE hProcess, const char *pszKey, const char *pszValue);	/**< ϐݒ */
const char    *Process_GetEnvString(HANDLE hProcess, const char *pszKey);						/**< ϐ擾 */

int           Process_SetCurrentDir(HANDLE hProcess, const char *pszPath);						/**< vZX̃JgfBNgݒ */
const char    *Process_GetCurrentDir(HANDLE hProcess);											/**< vZX̃JgfBNg擾 */

void          Process_SetTerminal(HANDLE hProcess, HANDLE hFile);								/**< vZX̕W^[~iݒ */
HANDLE        Process_GetTerminal(HANDLE hProcess);												/**< vZX̕W^[~i擾 */
void          Process_SetConIn(HANDLE hProcess, HANDLE hFile);									/**< vZX̕WR\[ݒ */
HANDLE        Process_GetConIn(HANDLE hProcess);				 								/**< vZX̕WR\[擾 */
void          Process_SetConOut(HANDLE hProcess, HANDLE hFile);									/**< vZX̕WR\[ݒ */
HANDLE        Process_GetConOut(HANDLE hProcess);				 								/**< vZX̕WR\[擾 */
void          Process_SetStdIn(HANDLE hProcess, HANDLE hFile);									/**< vZX̕W͐ݒ */
HANDLE        Process_GetStdIn(HANDLE hProcess);			   									/**< vZX̕W͎擾 */
void          Process_SetStdOut(HANDLE hProcess, HANDLE hFile);									/**< vZX̕Wo͐ݒ */
HANDLE        Process_GetStdOut(HANDLE hProcess);												/**< vZX̕Wo͎擾 */
void          Process_SetStdErr(HANDLE hProcess, HANDLE hFile);									/**< vZX̕WG[o͐ݒ */
HANDLE        Process_GetStdErr(HANDLE hProcess);												/**< vZX̕WG[o͎擾 */


#ifdef __cplusplus
}
#endif


#endif	/* __HOS__process_h__ */


/* end of file */
