/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  process.h
 * @brief %jp{vZXIuWFNg}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */

#include <string.h>
#include "hosaplfw.h"
#include "process_local.h"
#include "system/system/system_local.h"



static const T_HANDLEOBJ_METHODS Process_Methods =
	{
		Process_Delete,
	};


static void Process_Entry(void);
static void Process_SignalHandler(void);


/** RXgN^ */
PROCESS_ERR Process_Constructor(C_PROCESS *self, const T_HANDLEOBJ_METHODS *pMethods, const T_PROCESS_CREATE_INF *pInf)
{
	if ( pMethods == NULL )
	{
		pMethods = &Process_Methods;
	}

	/* oϐ */
	self->iExitCode     = -1;					/* IR[h */
	self->iSignal        = 0;					/* VOiԍ */
	self->pfncSignalProc = NULL;				/* VOinh */
	self->pHandleList    = NULL;				/* Lnh̃Xg(IɊJ) */
	self->pfncEntry      = pInf->pfncEntry;		/* NAhX */
	self->Param          = pInf->Param;			/* [U[p[^ */
	self->pEnv           = NULL;				/* ϐp */
	self->StackSize      = pInf->StackSize;		/* X^bNTCY */
	self->Priority       = pInf->Priority;		/* vZXDx */
	self->SysMode        = 0;					/* VXe[h */
	self->Exit           = 0;					/* ItO */
	self->hTerminal      = pInf->hTerminal;		/* ^[~i */
	self->hConIn         = pInf->hConIn;		/* R\[ */
	self->hConOut        = pInf->hConOut;		/* R\[o */
	self->hStdIn         = pInf->hStdIn;		/* W */
	self->hStdOut        = pInf->hStdOut;		/* Wo */
	self->hStdErr        = pInf->hStdErr;		/* WG[o */
	
	/* R}hCRs[ */
	if ( pInf->pszCommandLine != NULL )
	{
		if ( (self->pszCommandLine = (char *)SysMem_Alloc(strlen(pInf->pszCommandLine) + 1)) == NULL )
		{
			return PROCESS_ERR_NG;
		}
		strcpy(self->pszCommandLine, pInf->pszCommandLine);
	}
	else
	{
		self->pszCommandLine = NULL;
	}
	
	/* NfBNgRs[ */
	if ( pInf->pszCurrentDir != NULL )
	{
		if ( (self->pszCurrentDir = (char *)SysMem_Alloc(strlen(pInf->pszCurrentDir) + 1)) == NULL )
		{
			SysMem_Free(self->pszCommandLine);
			return PROCESS_ERR_NG;
		}
		strcpy(self->pszCurrentDir, pInf->pszCurrentDir);
	}
	else
	{
		self->pszCurrentDir = NULL;
	}
	
	/* X^bNpm */
	if ( (self->pStack = SysMem_Alloc(self->StackSize)) == NULL )
	{
		SysMem_Free(self->pszCommandLine);
		SysMem_Free(self->pszCurrentDir);
		return PROCESS_ERR_NG;
	}

	/* ҂킹pCxg */
	self->hEvt = SysEvt_Create(SYSEVT_ATTR_NORMAL);
	if ( self->hEvt == SYSEVT_HANDLE_NULL )
	{
		SysMem_Free(self->pStack);
		SysMem_Free(self->pszCommandLine);
		SysMem_Free(self->pszCurrentDir);
		return PROCESS_ERR_NG;
	}
	SysEvt_Clear(self->hEvt);
	
	/* vZX */
	self->hPrc = SysPrc_Create(Process_Entry, (VPARAM)self, self->pStack, self->StackSize, self->Priority, SYSPRC_ATTR_NORMAL);
	if ( self->hPrc == SYSPRC_HANDLE_NULL )
	{
		SysEvt_Delete(self->hEvt);
		SysMem_Free(self->pStack);
		SysMem_Free(self->pszCommandLine);
		SysMem_Free(self->pszCurrentDir);
		return PROCESS_ERR_NG;
	}
	
	/* VXeɓo^ */
	System_RegistryProcess(self);
	
	/* eNXRXgN^ */
	HandleObj_Constructor(&self->HandleObj, pMethods);
	
	/* vZXJn */
	SysPrc_Start(self->hPrc);
	
	/* N҂ */
	SysEvt_Wait(self->hEvt);
	
	return PROCESS_ERR_OK;
}


/* vZXGg[|Cg */
void Process_Entry(void)
{
	C_PROCESS	*self;
	int			(*pfncEntry)(VPARAM Param);
	VPARAM		ProcParam;
	int			iExitCode;
	
	self = (C_PROCESS *)SysPrc_GetParam(SysPrc_GetCurrentHandle());
	
	SysPrc_SetSignalHandler(SysPrc_GetCurrentHandle(), Process_SignalHandler);
	
	pfncEntry = self->pfncEntry;
	ProcParam = self->Param;

	SysEvt_Set(self->hEvt);
	
	if ( pfncEntry != NULL )
	{
		iExitCode = pfncEntry(ProcParam);
	}
	else
	{
		if ( Command_Execute(self->pszCommandLine, &iExitCode) != COMMAND_ERR_OK )
		{
			File_PutString(Process_GetStdErr(HANDLE_NULL), "command is not found.\n");
		}
	}
	
	Process_Exit(iExitCode);
}


/* VOiM|Cg */
void Process_SignalHandler(void)
{
	C_PROCESS	*self;

	self = (C_PROCESS *)SysPrc_GetParam(SysPrc_GetCurrentHandle());
	
	if ( self->pfncSignalProc != NULL )
	{
		self->pfncSignalProc(self->iSignal);
		return;
	}

	if ( self->iSignal == PROCESS_SIGNAL_KILL )
	{
		Process_Exit(-1);
	}
}


/* end of file */
