/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  process.h
 * @brief %jp{vZXIuWFNg}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */

#include "process_local.h"



/* vZX */
HANDLE Process_Create(const char *pszCommand, MEMSIZE StackSize, int Priority)
{
	T_PROCESS_CREATE_INF Inf;
	
	/* ftHgl */
	if ( StackSize == 0 )
	{
		StackSize = 4096;
	}
	if ( Priority == 0 )
	{
		Priority = PROCESS_PRIORITY_NORMAL;
	}
	
	Inf.pszCommandLine = pszCommand;							/**< R}hC */
	Inf.pszCurrentDir  = Process_GetCurrentDir(HANDLE_NULL);	/**< NfBNg */
	Inf.pfncEntry      = NULL;									/**< NAhX */
	Inf.Param          = 0;										/**< [U[p[^ */
	Inf.StackSize      = StackSize;								/**< X^bNTCY */
	Inf.Priority       = Priority;								/**< vZXDx */
	Inf.hTerminal      = Process_GetTerminal(HANDLE_NULL);		/**< ^[~i */
	Inf.hConIn         = Process_GetConIn(HANDLE_NULL);			/**< R\[ */
	Inf.hConOut        = Process_GetConOut(HANDLE_NULL);		/**< R\[o */
	Inf.hStdIn         = Process_GetStdIn(HANDLE_NULL);			/**< W */
	Inf.hStdOut        = Process_GetStdOut(HANDLE_NULL);		/**< Wo */
	Inf.hStdErr        = Process_GetStdErr(HANDLE_NULL);		/**< WG[o */
	
	return Process_CreateEx(&Inf);
}
	


/* end of file */
