/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  process.h
 * @brief %jp{vZXIuWFNg}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */

#include <string.h>
#include "process_local.h"
#include "system/system/system_local.h"


/** fXgN^ */
void Process_Destructor(C_PROCESS *self)
{
	/* vZX폜 */
	SysPrc_Delete(self->hPrc);
	
	/* ҂킹pCxg */
	SysEvt_Delete(self->hEvt);
	
	/* X^bNpJ */
	SysMem_Free(self->pStack);

	/* R}hCpJ */
	SysMem_Free(self->pszCommandLine);

	/* JgfBNgpJ */
	SysMem_Free(self->pszCurrentDir);
	
	/* VXeo^ */
	System_UnregistryProcess(self);
	
	/* ϐ폜 */
	if ( self->pEnv != NULL )
	{
		Assoc_Delete(self->pEnv);
	}
	
	/* eNXfXgN^Ăяo */
	HandleObj_Destructor(&self->HandleObj);
}


/* end of file */
