/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  process.h
 * @brief %jp{vZXIuWFNg}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__process_local_h__
#define __HOS__process_local_h__


#include "process.h"
#include "system/handle/handleobj_local.h"
#include "system/sysapi/sysapi.h"


/* vZXIuWFNg{NX` */
typedef struct c_process
{
	C_HANDLEOBJ			HandleObj;						/**< nhIuWFNgp */

	HANDLE				*pHandleList;					/**< Lnh̃Xg(IɊJ) */
	
	struct c_process	*pNext;							/*< ̃vZX */
	struct c_process	*pPrev;							/*< ÕvZX */
	
	SYSPRC_HANDLE		hPrc;							/**< vZXnh */
	SYSEVT_HANDLE		hEvt;							/**< ҂킹pCxg */
	int					iExitCode;						/**< IR[h */
	void				*pStack;						/**< X^bN̈̃ */

	char				*pszCommandLine;				/**< sR}h */
	char				*pszCurrentDir;					/**< JgfBNg */

	int					(*pfncEntry)(VPARAM Param);		/**< NAhX */
	VPARAM				Param;							/**< [U[p[^ */
	C_ASSOC				*pEnv;							/**< ϐp */

	void				(*pfncSignalProc)(int iSignal);	/**< VOiMvV[W */
	int					iSignal;						/**< [U[p[^ */

	MEMSIZE				StackSize;						/**< X^bNTCY */
	int					Priority;						/**< vZXDx */
	char				SysMode;						/**< VXe[h */
	char				Exit;							/**< ItO */
	HANDLE				hTerminal;						/**< ^[~i */
	HANDLE				hConIn;							/**< R\[ */
	HANDLE				hConOut;						/**< R\[o */
	HANDLE				hStdIn;							/**< W */
	HANDLE				hStdOut;						/**< Wo */
	HANDLE				hStdErr;						/**< WG[o */
} C_PROCESS;


#ifdef __cplusplus
extern "C" {
#endif

PROCESS_ERR Process_Constructor(C_PROCESS *self, const T_HANDLEOBJ_METHODS *pMethods, const T_PROCESS_CREATE_INF *pInf);		/**< RXgN^ */
void        Process_Destructor(C_PROCESS *self);																				/**< fXgN^ */

PROCESS_ERR Process_Attach(C_PROCESS *self, const T_HANDLEOBJ_METHODS *pMethods, const T_PROCESS_CREATE_INF *pInf);				/**< vZXA^b` */

#ifdef __cplusplus
}
#endif


#endif	/* __HOS__process_local_h__ */



/* end of file */
