/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  system.h
 * @brief %jp{VXepAPI`}
 *
 * Copyright (C) 2006-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


/* ITRON}CNJ[lƂāAˑ͂̃W[ŋɗ͉B */
/* VXe[h(foCXhCoȂ)݂̂ɋAPI` */
/* [U[[hpAPI͕ʓr쐬\ */


#ifndef __HOS__sysapi_h__
#define __HOS__sysapi_h__


#include "system/type/type.h"
#include "library/container/memheap/memheap.h"


/* vZXnh(VXep) */
#define SYSPRC_HANDLE_NULL			(0)
typedef void* SYSPRC_HANDLE;

/* ~[ebNXnh(VXep) */
#define SYSMTX_HANDLE_NULL			(0)
typedef void* SYSMTX_HANDLE;

/* Cxgnh(VXep) */
#define SYSEVT_HANDLE_NULL			(0)
typedef void* SYSEVT_HANDLE;

/* ݃T[rX[`nh(VXep) */
#define SYSISR_HANDLE_NULL			(0)
typedef void* SYSISR_HANDLE;

/* vZX(VXep) */
#define	SYSPRC_ATTR_NORMAL			0x00

/* Cxg(VXep) */
#define	SYSEVT_ATTR_NORMAL			0x00
#define	SYSEVT_ATTR_AUTOCLEAR		0x01

/* ~[ebNX(VXep) */
#define	SYSMTX_ATTR_NORMAL			0x00

/* Ǘp */
typedef _HOS_UINT64					SYSTIM_SYSTIME;
typedef _HOS_UINT64					SYSTIM_CPUTIME;


#ifdef __cplusplus
extern "C" {
#endif

/*  */
void           SysApi_Initialize(void *pMem, MEMSIZE MemSize, MEMSIZE MemAlign, void *pIoMem, MEMSIZE IoMemSize, MEMSIZE IoMemAlign);
																			/**< VXȅ */

/* VXeԎ擾 */
int            SysCtx_IsIsr(void);											/**< ISRReLXgǂׂ(VXep) */

/* VXebN */
void           SysLoc_Lock(void);											/**< VXeŜ̃bN(VXep) */
void           SysLoc_Unlock(void);											/**< VXeŜ̃bN(VXep) */

/* VXepAPI */
void          *SysMem_Alloc(MEMSIZE Size);									/**< ̊蓖(VXep) */
void          *SysMem_ReAlloc(void *pMem, MEMSIZE Size);					/**< ̍Ċ蓖(VXep) */
void           SysMem_Free(void *pMem);										/**< ̕ԋp(VXep) */
MEMSIZE        SysMem_GetSize(void *pMem);									/**< ̃TCY擾(VXep) */
C_MEMHEAP      *SysMem_GetMemHeap(void);									/**< C^[tF[X̎擾(VXep) */


/* VXepݐAPI */
void           SysInt_Enable(int iIntNum);									/**< ݋(VXep) */
void           SysInt_Disable(int iIntNum);									/**< ݋֎~(VXep) */
void           SysInt_Clear(int iIntNum);									/**< ݗvNA(VXep) */
void           SysInt_SetIntTime(int iIntNum, SYSTIM_CPUTIME Time);			/**< ݌v^C} */
SYSTIM_CPUTIME SysInt_GetIntTime(int iIntNum);								/**< ݌v^C}擾 */

/* ݃T[rX[`API */
SYSISR_HANDLE  SysIsr_Create(int iIntNum, void (*pfncIsr)(VPARAM Param), VPARAM Param);
void           SysIsr_Delete(SYSISR_HANDLE hIsr);

/* VXepvZXAPI */
SYSPRC_HANDLE  SysPrc_Create(void (*pfncEntry)(void), VPARAM Param, void *pStack, MEMSIZE StackSize, int Priority, int iAttr);
																			/**< vZX(VXep) */
void           SysPrc_Delete(SYSPRC_HANDLE hPrc);							/**< vZX폜(VXep) */
VPARAM         SysPrc_GetParam(SYSPRC_HANDLE hPrc);							/**< vZX̃p[^擾(VXep) */

void           SysPrc_Start(SYSPRC_HANDLE hPrc);							/**< vZXJn(VXep) */
void           SysPrc_Terminate(SYSPRC_HANDLE hPrc);						/**< vZXI(VXep) */
void           SysPrc_Suspend(SYSPRC_HANDLE hPrc);							/**< vZX~(VXep) */			
void           SysPrc_Resume(SYSPRC_HANDLE hPrc);							/**< vZX~(VXep) */	
void           SysPrc_SendSignal(SYSPRC_HANDLE hPrc);						/**< vZXւ̃VOiM(VXep) */
void           SysPrc_SetSignalHandler(SYSPRC_HANDLE hPrc, void (*pfncHanler)(void));
																			/**< vZXւ̃VOinho^(VXep) */
SYSPRC_HANDLE  SysPrc_GetCurrentHandle(void);								/**< ݂̃vZX̎擾(VXep) */
void           SysPrc_SetExecTime(SYSPRC_HANDLE hPrc, SYSTIM_CPUTIME Time);	/**< vZXsԌv^C} */
SYSTIM_CPUTIME SysPrc_GetExecTime(SYSPRC_HANDLE hPrc);						/**< vZXsԌv^C}擾 */

/* VXep~[ebNXAPI */
SYSMTX_HANDLE  SysMtx_Create(int iAttr);									/**< ~[ebNX(VXep) */
void           SysMtx_Delete(SYSMTX_HANDLE hMtx);							/**< ~[ebNX폜(VXep) */
int            SysMtx_PolingLock(SYSMTX_HANDLE hMtx);						/**< ~[ebNX|[ObN(VXep) */
void           SysMtx_Lock(SYSMTX_HANDLE hMtx);								/**< ~[ebNXbN(VXep) */
void           SysMtx_Unlock(SYSMTX_HANDLE hMtx);							/**< ~[ebNXbN(VXep) */
int            SysMtx_RefStatus(SYSMTX_HANDLE hMtx);						/**< ~[ebNX̏Ԃ擾(VXep) */

/* VXepCxgAPI */
SYSEVT_HANDLE  SysEvt_Create(int iAttr);									/**< Cxg(VXep) */
void           SysEvt_Delete(SYSEVT_HANDLE hEvt);							/**< Cxg폜(VXep) */
void           SysEvt_Wait(SYSEVT_HANDLE hEvt);								/**< Cxg҂(VXep) */
void           SysEvt_Set(SYSEVT_HANDLE hEvt);								/**< CxgZbg(VXep) */
void           SysEvt_Clear(SYSEVT_HANDLE hEvt);							/**< CxgNA(VXep) */
int            SysEvt_RefStatus(SYSEVT_HANDLE hEvt);						/**< Cxg̏Ԃ擾(VXep) */

/* ԊǗ */
void           SysTim_Signal(unsigned long ulTic);							/**< VXe^CɃeBbN^(VXep) */
void           SysTim_Wait(unsigned long ulTime);							/**< ԑ҂(VXep) */
TIME           SysTim_GetCurrentTime(void);									/**< ݂̎擾(VXep) */
SYSTIM_SYSTIME SysTim_GetSystemTime(void);									/**< ݂̃VXe擾(VXep) */
unsigned long  SysTim_SysTimeToSecond(SYSTIM_SYSTIME SysTime);				/**< VXebɊZ(VXep) */
unsigned long  SysTim_SysTimeToNanosecond(SYSTIM_SYSTIME SysTime);			/**< VXeimbɊZ(VXep) */
SYSTIM_CPUTIME SysTim_GetCpuTime(void);										/**< ݂CPU擾(VXep) */
unsigned long  SysTim_CpuTimeToSecond(SYSTIM_CPUTIME CpuTime);				/**< CPUbɊZ(VXep) */
unsigned long  SysTim_CpuTimeToNanosecond(SYSTIM_CPUTIME CpuTime);			/**< CPUimbɊZ(VXep) */


/* I/OANZX */
#ifdef __HOSAPLFW_IOMAPEDIO
/* I/O}bvhI/O  */
unsigned char  SysIo_InPortB(void *Port);									/**< I/O|[goCg(8bit) */
unsigned short SysIo_InPortH(void *Port);									/**< I/O|[gn[t[h(16bit) */
unsigned long  SysIo_InPortW(void *Port);									/**< I/O|[g烏[h(32bit) */
unsigned char  SysIo_OutPortB(void *Port, unsigned char Data);				/**< I/O|[gփoCg(8bit)o */
unsigned short SysIo_OutPortH(void *Port, unsigned short Data);				/**< I/O|[gփn[t[h(16bit)o */
unsigned long  SysIo_OutPortW(void *Port, unsigned long Data);				/**< I/O|[gփ[h(32bit)o */
unsigned char  SysIo_AndPortB(void *Port, unsigned char Data);				/**< I/O|[goCg(8bit)PʂŘ_ */
unsigned short SysIo_AndPortH(void *Port, unsigned short Data); 		 	/**< I/O|[gn[t[h(16bit)PʂŘ_ */
unsigned long  SysIo_AndPortW(void *Port, unsigned long Data);  		 	/**< I/O|[g[h(32bit)PʂŘ_ */
unsigned char  SysIo_OrPortB(void *Port, unsigned char Data);				/**< I/O|[goCg(8bit)PʂŘ_a */
unsigned short SysIo_OrPortH(void *Port, unsigned short Data);				/**< I/O|[gn[t[h(16bit)PʂŘ_a */
unsigned long  SysIo_OrPortW(void *Port, unsigned long Data);				/**< I/O|[g[h(32bit)PʂŘ_a */
unsigned char  SysIo_XorPortB(void *Port, unsigned char Data);				/**< I/O|[goCg(8bit)PʂŔrI_a */
unsigned short SysIo_XorPortH(void *Port, unsigned short Data);				/**< I/O|[gn[t[h(16bit)PʂŔrI_a */
unsigned long  SysIo_XorPortW(void *Port, unsigned long Data);				/**< I/O|[g[h(32bit)PʂŔrI_a */
#else
/* }bvhI/O */
#define        SysIo_InPortB(Port)			(*(volatile unsigned char *)(Port))
#define        SysIo_InPortH(Port)			(*(volatile unsigned short *)(Port))
#define        SysIo_InPortW(Port)			(*(volatile unsigned long *)(Port))
#define        SysIo_OutPortB(Port, Data)	(*(volatile unsigned char *)(Port) = (unsigned char)(Data))
#define        SysIo_OutPortH(Port, Data)	(*(volatile unsigned short *)(Port) = (unsigned short)(Data))
#define        SysIo_OutPortW(Port, Data)	(*(volatile unsigned long *)(Port) = (unsigned long)(Data))
#define        SysIo_AndPortB(Port, Data)	(*(volatile unsigned char *)(Port) &= (unsigned char)(Data))
#define        SysIo_AndPortH(Port, Data)	(*(volatile unsigned short *)(Port) &= (unsigned short)(Data))
#define        SysIo_AndPortW(Port, Data)	(*(volatile unsigned long *)(Port) &= (unsigned long)(Data))
#define        SysIo_OrPortB(Port, Data)	(*(volatile unsigned char *)(Port) |= (unsigned char)(Data))
#define        SysIo_OrPortH(Port, Data)	(*(volatile unsigned short *)(Port) |= (unsigned short)(Data))
#define        SysIo_OrPortW(Port, Data)	(*(volatile unsigned long *)(Port) |= (unsigned long)(Data))
#define        SysIo_XorPortB(Port, Data)	(*(volatile unsigned char *)(Port) ^= (unsigned char)(Data))
#define        SysIo_XorPortH(Port, Data)	(*(volatile unsigned short *)(Port) ^= (unsigned short)(Data))
#define        SysIo_XorPortW(Port, Data)	(*(volatile unsigned long *)(Port) ^= (unsigned long)(Data))
#endif

/* VXeɂĂ͓AhX͈͂ɂDMAgȂALbV̈悪KvȂ̂ŕʓr݂ */
void          *SysIo_AllocIoMem(MEMSIZE Size);								/**< I/OɓK̊蓖(VXep) */
void           SysIo_FreeIoMem(void *pMem);									/**< I/OɓK̕ԋp(VXep) */


#ifdef __cplusplus
}
#endif


#endif

