/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  system.h
 * @brief %jp{VXepAPI`}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <stdio.h>
#include <string.h>
#include "sysapi_local.h"
#include "kernel.h"


C_SYSMEMHEAP		SysMem_SysMemHeap;			/* VXe */
C_VALMEMHEAP		SysMem_ValMemHeap;			/* VXeq[v */

SYSMTX_HANDLE		SysIo_hMtx;					/* I/Opq[vǗp~[ebNX */
C_VALMEMHEAP		*SysIo_pValMemHeap = NULL;	/* I/Opq[v */

T_SYSPRC_INF		*SysPrc_InfTbl;				/* vZXǗpe[u */
T_SYSINT_INF		*SysInt_InfTbl;				/* INTǗpe[u */



/* VXȅ */
void SysApi_Initialize(void *pMem, MEMSIZE MemSize, MEMSIZE MemAlign, void *pIoMem, MEMSIZE IoMemSize, MEMSIZE IoMemAlign)
{
	/* Ǘ̏ */
	ValMemHeap_Constructor(&SysMem_ValMemHeap, pMem, MemSize, MemAlign);			/* q[v */
	SysMemHeap_Constructor(&SysMem_SysMemHeap, (C_MEMHEAP *)&SysMem_ValMemHeap);
	
	/* vZXǗe[um */
	SysPrc_InfTbl = (T_SYSPRC_INF *)SysMem_Alloc(sizeof(T_SYSPRC_INF) * (_kernel_max_tskid + 1));
	memset(SysPrc_InfTbl, 0, sizeof(T_SYSPRC_INF) * _kernel_max_tskid);

	/* ISRǗe[um */
	SysInt_InfTbl = (T_SYSINT_INF *)SysMem_Alloc(sizeof(T_SYSINT_INF) * (_kernel_max_intno - _kernel_min_intno + 1));
	memset(SysInt_InfTbl, 0, sizeof(T_SYSINT_INF) * (_kernel_max_intno - _kernel_min_intno + 1));
	
	/* I/OpǗ */
	if ( pIoMem != NULL )
	{
		SysIo_hMtx = SysMtx_Create(SYSMTX_ATTR_NORMAL);								/* Ǘprp~[ebNX */	
		SysIo_pValMemHeap = SysMem_Alloc(sizeof(C_VALMEMHEAP));
		ValMemHeap_Constructor(SysIo_pValMemHeap, pIoMem, IoMemSize, IoMemAlign);	/* q[v */	
	}
}


/* end of file */
