/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  system.h
 * @brief %jp{VXepAPI` HOS-V4a p}
 *
 * Copyright (C) 2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__sysapi_local_h__
#define __HOS__sysapi_local_h__


#include "kernel.h"
#include "sysapi.h"
#include "system/sysmem/sysmemheap_local.h"
#include "library/container/valmemheap/valmemheap_local.h"

#define _HOS_SYSPAI_USEMTX


/* HOS-V4a ϐ̎Q(C`L) */
extern const ID		_kernel_max_tskid;
extern const INTNO	_kernel_min_intno;
extern const INTNO	_kernel_max_intno;


/* vZXŗLǗ */
typedef struct t_sysprc_inf
{
	VPARAM				Param;					/* vZXŗLp[^ */
	SYSTIM_CPUTIME		ExecTime;				/* vZXsԌv */
} T_SYSPRC_INF;


/* ISRŗLǗ */
typedef struct t_sysint_inf
{
	SYSTIM_CPUTIME		ExecTime;				/* INTsԌv */
} T_SYSINT_INF;

extern C_SYSMEMHEAP		SysMem_SysMemHeap;		/* VXe */
extern C_VALMEMHEAP		SysMem_ValMemHeap;		/* VXeq[v */
extern SYSMTX_HANDLE	SysIo_hMtx;				/* I/Opq[vǗp~[ebNX */
extern C_VALMEMHEAP		*SysIo_pValMemHeap;		/* I/Opq[v */
extern T_SYSPRC_INF		*SysPrc_InfTbl;			/* vZXǗpe[u */
extern T_SYSINT_INF		*SysInt_InfTbl;			/* ISRǗpe[u */
extern SYSTIM_CPUTIME	SysTim_TimeCounter;		/* ftHg̃^C}JE^ */



#ifdef __cplusplus
extern "C" {
#endif

#ifdef __cplusplus
}
#endif


#endif	/* __HOS__sysapi_local_h__ */


/* end of file */
