/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  system.h
 * @brief %jp{VXepAPI`}
 *
 * Copyright (C) 2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <stdio.h>
#include "sysapi_local.h"


/* I/Op̂̊蓖 */
void *SysIo_AllocIoMem(MEMSIZE Size)
{
	void *pMem;

	/* ʏ탁ƌp */
	if ( SysIo_pValMemHeap == NULL )
	{
		return SysMem_Alloc(Size);
	}
	
	/* I/Op̈悩犄蓖 */
	SysMtx_Lock(SysIo_hMtx);
	pMem = ValMemHeap_Alloc(SysIo_pValMemHeap, Size);
	SysMtx_Unlock(SysIo_hMtx);
	
	return pMem;
}


/* end of file */
