/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  sysmemheap_alloc.c
 * @brief %jp{VXeq[vNX}%en{system memory heap class}
 *
 * Copyright (C) 2006-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <stdio.h>
#include "sysmemheap_local.h"



/** %jp{MemHeapNX z֐e[u}%en{MemHeap class virtual function table} */
const static T_MEMHEAP_METHODS SysMemHeap_Methods =
	{
		SysMemHeap_Alloc,			/**< ̊蓖 */
		SysMemHeap_ReAlloc,			/**< ̍Ċ蓖 */
		SysMemHeap_Free,			/**< ̊J */
		SysMemHeap_GetSize,			/**< ̃TCY擾 */
		SysMemHeap_GetAlign,		/**< ACg̎擾 */
		SysMemHeap_AlignSize,		/**< TCYACgPʂɊg */
	};



/** %jp{RXgN^} */
void SysMemHeap_Constructor(C_SYSMEMHEAP *self, C_MEMHEAP *pMemHeap)
{
	self->hMtx     = SysMtx_Create(SYSMTX_ATTR_NORMAL);
	self->pMemHeap = pMemHeap;
	
	/* %jp{eNXRXgN^} */
	MemHeap_Constructor(&self->MemHeap, &SysMemHeap_Methods);
}


/* end of file */
