/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  sysmemheap_alloc.c
 * @brief %jp{VXeq[vNX}%en{system memory heap class}
 *
 * Copyright (C) 2006-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#ifndef __HOS__sysmemheap_local_h__
#define __HOS__sysmemheap_local_h__


#include "library/container/memheap/memheap_local.h"
#include "system/sysapi/sysapi.h"



/** %jp{SysMemHeapNX}%en{SysMemHeap class} */
typedef struct c_sysmemheap
{
	C_MEMHEAP			MemHeap;		/* p */
	
	C_MEMHEAP			*pMemHeap;		/* Ϗ֌W */
	SYSMTX_HANDLE		hMtx;
} C_SYSMEMHEAP;


#ifdef __cplusplus
extern "C" {
#endif

void	SysMemHeap_Constructor(C_SYSMEMHEAP *self, C_MEMHEAP *pMemHeap);
void    SysMemHeap_Destructor(C_SYSMEMHEAP *self);

void	*SysMemHeap_Alloc(void *pMemHeap, MEMSIZE Size);					/**< ̊蓖 */
void	*SysMemHeap_ReAlloc(void *pMemHeap, void *pMem, MEMSIZE Size);		/**< ̍Ċ蓖 */
void	SysMemHeap_Free(void *pMemHeap, void *pMem);						/**< ̊J */
MEMSIZE	SysMemHeap_GetSize(void *pMemHeap, void *pMem);						/**< ̃TCY擾 */
MEMSIZE	SysMemHeap_GetAlign(void *pMemHeap);								/**< ACg̎擾 */
MEMSIZE	SysMemHeap_AlignSize(void *pMemHeap, MEMSIZE Size);					/**< TCYACgPʂɊg */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS__sysmemheap_local_h__ */


/* end of file */
