/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  system.h
 * @brief %jp{VXepAPI`}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#ifndef __HOS__system_h__
#define __HOS__system_h__


#include "system/type/type.h"


/* VXe */
typedef struct t_system_initialize_inf
{
	void	*pSysMemBase;					/**< VXeq[vɊ蓖Ă̈̐擪AhX */
	MEMSIZE	SysMemSize;						/**< VXeq[ṽTCY */
	MEMSIZE	SysMemAlign;					/**< VXeq[ṽACgP */
	
	void	*pIoMemBase;					/**< I/Op̃q[v̈ */
	MEMSIZE	IoMemSize;						/**< I/Op̃q[v̈TCY */
	MEMSIZE	IoMemAlign;						/**< I/Op̃q[ṽACgP */
	
	MEMSIZE	SystemStackSize;				/**< VXevZXɊ蓖ĂX^bNTCY */
	
	int		(*pfncBoot)(VPARAM Param);		/**< u[gvZX̋NԒn */	
	MEMSIZE	BootStackSize;					/**< u[gvZXɊ蓖ĂX^bNTCY */
	VPARAM	BootParam;						/**< u[gvZX̃p[^ */
} T_SYSTEM_INITIALIZE_INF;


#ifdef __cplusplus
extern "C" {
#endif

void   System_Initialize(const T_SYSTEM_INITIALIZE_INF *pInf);												/**< VXe */
int    System_RequestProc(void (*pfncProc)(VPARAM Param1, VPARAM Param2), VPARAM Param1, VPARAM Param2);	/**< VXevZXւ̏˗ */

void   System_Lock(void);
void   System_Unlock(void);

HANDLE System_GetNextProcess(HANDLE hProcess);																/**< ̃vZX擾 */


void          Whiteboard_SetString(const char *pszKey, const char *pszValue);
const char   *Whiteboard_GetString(const char *pszKey, char *pszBuf, int iBufSize, const char *pszDefault);
void          Whiteboard_SetInteger(const char *pszKey, unsigned long ulValue);
unsigned long Whiteboard_GetInteger(const char *pszKey, unsigned long ulDefault);
const char   *Whiteboard_GetNextKey(const char *pszKey, char *pszBuf, int iBufSize);

#ifdef __cplusplus
}
#endif


#endif	/* __HOS__system_h__ */


/* end of file */
