/** 
 * $PROJECT_NAME$
 *
 * @file  xxxxdrv_local.h
 * @brief %jp{$OBJNAME_JP$ [Jwb_t@C}%en{$OBJNAME_EN$ private header file}
 *
 * $COPYRIGHT$
 */


#ifndef __ZZZZ__xxxxdrv_local_h__
#define __ZZZZ__xxxxdrv_local_h__


#include "xxxxdrv.h"
#include "system/file/syncdrv_local.h"
#include "library/container/streambuf/streambuf.h"
#include "system/sysapi/sysapi.h"



/** %jp{hCoNX}%en{Device driver class} */
typedef struct c_xxxxdrv
{
	C_SYNCDRV		SyncDrv;		/**< %jp{@\tfoCXhCop} */

	void			*pRegBase;		/**< %jp{WX^x[XAhX} */
	unsigned long	ulBaseClock;	/**< %jp{x[XNbN} */
	int				iIntNum;		/**< %jp{ݔԍ} */
	SYSISR_HANDLE	hIsr;			/**< %jp{݃T[rX[`nh} */

	int				iOpenCount;		/**< %jp{I[vJE^} */
	
	C_STREAMBUF		StmBufRecv;		/**< %jp{Mobt@} */
} C_XXXXDRV;




#ifdef __cplusplus
extern "C" {
#endif

FILE_ERR  XxxxDrv_Constructor(C_XXXXDRV *self, const T_DRVOBJ_METHODS *pMethods, void *pRegBase, int iIntNum, unsigned long ulBaseClock, int iBufSize);
																												/**< RXgN^ */
void      XxxxDrv_Destructor(C_XXXXDRV *self);																	/**< fXgN^ */

HANDLE    XxxxDrv_Open(C_DRVOBJ *pDrvObj, const char *pszPath, int iMode);
void      XxxxDrv_Close(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj);
FILE_ERR  XxxxDrv_IoControl(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, int iFunc, void *pInBuf, FILE_SIZE InSize, const void *pOutBuf, FILE_SIZE OutSize);
FILE_POS  XxxxDrv_Seek(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, FILE_POS Offset, int iOrign);
FILE_SIZE XxxxDrv_Read(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, void *pBuf, FILE_SIZE Size);
FILE_SIZE XxxxDrv_Write(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, const void *pData, FILE_SIZE Size);
FILE_ERR  XxxxDrv_Flush(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj);

void      XxxxDrv_Isr(VPARAM Param);			/**< %jp{ݏ} */


#ifdef __cplusplus
}
#endif


#endif	/* __ZZZZ__xxxxdrv_local_h__ */


/* end of file */
