/** 
 * $PROJECT_NAME$
 *
 * @file  xxxxdrv_constructor.c
 * @brief %jp{$OBJNAME_JP$ IuWFNg폜}%en{$OBJNAME_EN$  delete object}
 *
 * $COPYRIGHT$
 */


#include "xxxxdrv_local.h"



/** %jp{z֐e[u}%en{virtual functions table} */
const T_DRVOBJ_METHODS XxxxDrv_Methods = 
	{
		{ XxxxDrv_Delete },
		XxxxDrv_Open,
		XxxxDrv_Close,
		XxxxDrv_IoControl,
		XxxxDrv_Seek,
		XxxxDrv_Read,
		XxxxDrv_Write,
		XxxxDrv_Flush,
	};



/** RXgN^ */
FILE_ERR XxxxDrv_Constructor(C_XXXXDRV *self, const T_DRVOBJ_METHODS *pMethods, void *pRegBase, int iIntNum)
{
	FILE_ERR	ErrCode;
	
	/* z֐e[u */
	if ( pMethods == NULL )
	{
		pMethods = &XxxxDrv_Methods;
	}
		
	/* eNXRXgN^Ăяo */
	if ( (ErrCode = SyncDrv_Constructor(&self->SyncDrv, pMethods, SYNCDRV_FACTOR_NUM)) != FILE_ERR_OK )
	{
		return ErrCode;
	}
	
	/* oϐ */
	self->pRegBase    = pRegBase;
	self->iIntNum     = iIntNum;
	self->iOpenCount  = 0;

	
	/* ݏo^ */
	self->hIsr = SysIsr_Create(self->iIntNum, XxxxDrv_Isr, (VPARAM)self);
	if ( self->hIsr == SYSISR_HANDLE_NULL )
	{
		SyncDrv_Destructor(&self->SyncDrv);
		return FILE_ERR_NG;		
	}
	
	return FILE_ERR_OK;
}


/* end of file */
