/**
 *  Hyper Operating System V4 Advance Configurator
 *
 * @file  apidef.cpp
 * @brief  %jp{API`NX}%en{API definition cless}
 *
 * Copyright (C) 1998-2010 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <stdio.h>
#include <stdlib.h>
#include "defercd.h"
#include "apidef.h"
#include "analyze.h"



// RXgN^
CApiDef::CApiDef()
{
	int i;

	m_iDefaultMaxId = 0;
	m_iMaxId        = -1;
	m_iObjs         = 0;
	m_iResObj       = 0;
	for ( i = 0; i < API_MAX_OBJS; i++ )
	{
		m_pParamPacks[i] = NULL;
		m_iId[i]         = 0;
	}
}


// fXgN^
CApiDef::~CApiDef()
{
	int i;

	for ( i = 0; i < API_MAX_OBJS; i++ )
	{
		delete m_pParamPacks[i];
	}
}


// p[^[ǉi蔲j
int CApiDef::AddParams(const char* pszParams)
{
	char szParamBlock[API_MAX_PARAM];
	char szParam[API_MAX_PARAM];
	int  iErr = 0;
	int  iIndex = 0;
	int  i, j;

	// p[^i[pIuWFNg
	m_pParamPacks[m_iObjs] = new CParamPack();

	for ( i = 0; i < m_iParams; i++ )
	{
		if ( m_iParamSyntax[i] == 0 )
		{
			// Pƃp[^[؂o
			iErr = CAnalyze::GetParameter(szParam, pszParams);
			if ( iErr != CFG_ERR_OK )
			{
				break;
			}

			// p[^[ǉ
			CAnalyze::SpaceCut(szParam);
			m_pParamPacks[m_iObjs]->SetParam(iIndex++, szParam);
		}
		else
		{
			// 󔒓ǂݔ΂
			while ( *pszParams == ' ' )
			{
				pszParams++;
			}

			// ubNJn`FbN
			if ( *pszParams++ != '{' )
			{
				iErr = CFG_ERR_SYNTAX;
				break;
			}
			
			// ubN؂o
			iErr = CAnalyze::SearchChar(szParamBlock, pszParams, '}');
			if ( iErr != CFG_ERR_OK )
			{
				break;
			}

			// ubNǂݏo
			const char* pszParamBlock = szParamBlock;
			for ( j = 0; j < m_iParamSyntax[i] + 1; j++ )
			{
				// Pƃp[^[؂o
				iErr = CAnalyze::GetParameter(szParam, pszParamBlock);
				if ( iErr != CFG_ERR_OK )
				{
					break;
				}

				// p[^[ǉ
				CAnalyze::SpaceCut(szParam);
				if ( szParam[0] == '\0')
				{
					break;
				}
				m_pParamPacks[m_iObjs]->SetParam(iIndex++, szParam);
			}
			if ( iErr != CFG_ERR_OK )
			{
				iErr = CFG_ERR_SYNTAX;
				break;
			}
			if ( j != m_iParamSyntax[i] )
			{
				iErr = CFG_ERR_PARAM;
				break;
			}
		}
	}

	if ( iErr == CFG_ERR_OK )
	{
		m_iObjs++;
	}

	return iErr;
}


// IDԍ蓖
int CApiDef::AutoId(void)
{
	bool blUsedId[65536];
	int iId;
	int i;
	
	if ( m_iObjs > 0 )
	{
		// ϐ
		for ( i = 0; i < 65536; i++ )
		{
			blUsedId[i] = false;
		}
		
		// ŒlwIDT[`
		for ( i = 0; i < m_iObjs; i++ )
		{
			iId = atoi(m_pParamPacks[i]->GetParam(0));
			if ( iId > 0 )
			{
				if ( m_iId[i] != 0 )
				{
					return CFG_ERR_ID_CONFLICT;		// IDՓ
				}
				m_iId[i] = iId;
				blUsedId[iId - 1] = true;
				if ( iId > m_iMaxId )
				{
					m_iMaxId = iId;
				}
			}
		}

		// ID 
		iId = 1;
		for ( i = 0; i < m_iObjs; i++ )
		{
			if ( m_iId[i] == 0 )
			{
				// gpςID̃XLbv
				while ( blUsedId[iId - 1] )
				{
					iId++;
				}
				m_iId[i] = iId++;
			}
		}
		iId--;

		if ( iId > m_iMaxId )
		{
			m_iMaxId = iId;
		}
	}
	
	// őIDԍ\IuWFNg
	if ( m_iResObj > 0 && m_iMaxId < m_iObjs + m_iResObj )
	{
		m_iMaxId = m_iObjs + m_iResObj;
	}
	
	// w肪ꍇ̓ftHglɐݒ
	if ( m_iMaxId < 0 )
	{
		m_iMaxId = m_iDefaultMaxId;
	}

	return 0;
}


// IDIuWFNgԍɕϊ
int CApiDef::IdToObjNum(int iId)
{
	int i;

	// ID̈vIuWFNgT
	for ( i = 0; i < m_iObjs; i++ )
	{
		if ( m_iId[i] == iId )
		{
			return i;
		}
	}

	return -1;
}



// ID `t@Co
void CApiDef::WriteId(FILE* fpId)
{
}


// cfgt@C`o
void CApiDef::WriteCfgDef(FILE* fpCfg)
{
}

// cfgt@Co
void CApiDef::WriteCfgIni(FILE* fpCfg)
{
}

// cfgt@CNo
void CApiDef::WriteCfgStart(FILE* fpCfg)
{
}

// end of file
