// ---------------------------------------------------------------------------
//  Hyper Operating System V4 Advance  configurator
//    CRE_CYC API
//                                                                            
//                                    Copyright (C) 1998-2010 by Project HOS
//                                    http://sourceforge.jp/projects/hos/
// ---------------------------------------------------------------------------



#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "defercd.h"
#include "crecyc.h"
#include "analyze.h"
#include "readcfg.h"



#define CRECYC_CYCID		0
#define CRECYC_CYCATR		1
#define CRECYC_EXINF		2
#define CRECYC_CYCHDR		3
#define CRECYC_CYCTIM		4
#define CRECYC_CYCPHS		5



// RXgN^
CApiCreCyc::CApiCreCyc()
{
	// %jp{ftHg̍őIDݒ}
	m_iDefaultMaxId = _KERNEL_DEF_TMAX_CYCID;
	
	// p[^[\ݒ
	m_iParamSyntax[0] = 0;		// Pƃp[^[
	m_iParamSyntax[1] = 5;		// 5p[^[̃ubN
	m_iParams = 2;
}

// fXgN^
CApiCreCyc::~CApiCreCyc()
{
}


// APỈ
int CApiCreCyc::AnalyzeApi(const char* pszApiName, const char* pszParams)
{
	if ( strcmp(pszApiName, "CRE_CYC") == 0 )
	{
		return AddParams(pszParams);
	}
	else if ( strcmp(pszApiName, "KERNEL_MAX_CYCID") == 0 )
	{
		int iId;

		if ( m_iMaxId > 0 )
		{
			return CFG_ERR_MULTIDEF;
		}

		if ( m_iResObj > 0 )
		{
			return CFG_ERR_DEF_CONFLICT;
		}

		if ( (iId = atoi(pszParams)) <= 0 )
		{
			return CFG_ERR_PARAM;
		}

		m_iMaxId = iId;

		return CFG_ERR_OK;
	}
	else if ( strcmp(pszApiName, "KERNEL_RSV_CYCID") == 0 )
	{
		int iId;

		if ( m_iMaxId > 0 )
		{
			return CFG_ERR_DEF_CONFLICT;
		}

		if ( (iId = atoi(pszParams)) <= 0 )
		{
			return CFG_ERR_PARAM;
		}

		m_iResObj += iId;

		return CFG_ERR_OK;
	}


	return CFG_ERR_NOPROC;
}


// ID `t@Co
void CApiCreCyc::WriteId(FILE* fp)
{
	int i;

	// %jp{Rgo}
	fputs("\n\n/* Semaphore object ID definetion */\n\n", fp);


	// %jp{ID`o}
	for ( i = 0; i < m_iObjs; i++ )
	{
		if ( atoi(m_pParamPacks[i]->GetParam(CRECYC_CYCID)) == 0 )
		{
			fprintf(
				fp,
				"#define %s\t\t%d\n",
				m_pParamPacks[i]->GetParam(CRECYC_CYCID),
				m_iId[i]);
		}
	}
	
	// %jp{IDől`o}
	fprintf( fp,
		"\n"
		"#ifdef  TMAX_CYCID\n"
		"#undef  TMAX_CYCID\n"
		"#endif\n"
		"\n"
		"#define TMAX_CYCID\t\t%d\n\n", m_iMaxId );
}


// cfgt@C`o
void  CApiCreCyc::WriteCfgDef(FILE* fp)
{
	int  i;

	// Rgo
	fputs(
		"\n\n\n"
		"/* ------------------------------------------ */\n"
		"/*       create cyclic handler objects        */\n"
		"/* ------------------------------------------ */\n"
		, fp);

	if ( m_iMaxId > 0 )
	{
#if _KERNEL_CYCCB_ALGORITHM == _KERNEL_CYCCB_ALG_BLKARRAY
#if _KERNEL_CYCCB_SPLIT_RO
	// %jp{ubNzROM}
	{
		// %jp{RAMo}
		fprintf(fp, "\n_KERNEL_T_CYCCB _kernel_cyccb_tbl[%d] =\n\t{\n", m_iMaxId);
		for ( i = 1; i <= m_iMaxId; i++ )
		{
			int iObjNum = IdToObjNum(i);
			if ( iObjNum >= 0 )
			{
				fprintf(fp, "\t\t{");
				WriteSemcbRam(fp, iObjNum);
				fprintf(fp, "},\n");
			}
			else
			{
				fprintf(fp, "\t\t{0},\n");
			}
		}
		fprintf(fp, "\t};\n");

		// %jp{ROMo}
		fprintf(fp, "\nconst _KERNEL_T_CYCCB_RO _kernel_cyccb_ro_tbl[%d] =\n\t{\n", m_iMaxId);
		for ( i = 1; i <= m_iMaxId; i++ )
		{
			int iObjNum = IdToObjNum(i);
			if ( iObjNum >= 0 )
			{
				fprintf(fp, "\t\t{");
				WriteSemcbRom(fp, iObjNum);
				fprintf(fp, "},\n");
			}
			else
			{
				fprintf(fp, "\t\t{0},\n");
			}
		}
		fprintf(fp, "\t};\n\n");
	}
#else
	// %jp{ubNz񁕓CYCCB}
	{
		// %jp{RAMo}
		fprintf(fp, "\n_KERNEL_T_CYCCB _kernel_cyccb_tbl[%d] =\n\t{\n", m_iMaxId);
		for ( i = 1; i <= m_iMaxId; i++ )
		{
			int iObjNum = IdToObjNum(i);
			if ( iObjNum >= 0 )
			{
				fprintf(fp, "\t\t{");
				WriteCyccbRam(fp, iObjNum);
				WriteCyccbRom(fp, iObjNum);
				fprintf(fp, "},\n");
			}
			else
			{
				fprintf(fp, "\t\t{{0}, },\n");
			}
		}
		fprintf(fp, "\t};\n");
	}
#endif
#elif _KERNEL_CYCCB_ALGORITHM == _KERNEL_CYCCB_ALG_PTRARRAY
#if _KERNEL_CYCCB_SPLIT_RO
	// %jp{|C^zROM}
	{
		fprintf(fp, "\n");
		for ( i = 0; i < m_iObjs; i++ )
		{
			fprintf(fp, "const _KERNEL_T_CYCCB_RO _kernel_cyccb_ro_blk_%d = {", m_iId[i]);
			WriteCyccbRom(fp, i);
			fprintf(fp, "};\n");
		}
		fprintf(fp, "\n");
		for ( i = 0; i < m_iObjs; i++ )
		{
			fprintf(fp, "_KERNEL_T_CYCCB _kernel_cyccb_blk_%d = {", m_iId[i]);
			WriteCyccbRam(fp, i);
			fprintf(fp, "};\n");
		}
		fprintf(fp, "\n");
		fprintf(fp, "\n_KERNEL_T_CYCCB *_kernel_cyccb_tbl[%d] =\n\t{\n", m_iMaxId);
		for ( i = 1; i <= m_iMaxId; i++ )
		{
			int iObjNum = IdToObjNum(i);
			if ( iObjNum >= 0 )
			{
				fprintf(fp, "\t\t&_kernel_cyccb_blk_%d,\n", i);
			}
			else
			{
				fprintf(fp, "\t\tNULL,\n");
			}
		}
		fprintf(fp, "\t};\n");		
	}
#else
	// %jp{|C^z񁕓CYCCB}
	{
		fprintf(fp, "\n");
		for ( i = 0; i < m_iObjs; i++ )
		{
			fprintf(fp, "_KERNEL_T_CYCCB _kernel_cyccb_blk_%d = {", m_iId[i]);
			WriteCyccbRam(fp, i);
			WriteCyccbRom(fp, i);
			fprintf(fp, "};\n");
		}
		fprintf(fp, "\n");
		fprintf(fp, "\n_KERNEL_T_CYCCB *_kernel_cyccb_tbl[%d] =\n\t{\n", m_iMaxId);
		for ( i = 1; i <= m_iMaxId; i++ )
		{
			int iObjNum = IdToObjNum(i);
			if ( iObjNum >= 0 )
			{
				fprintf(fp, "\t\t&_kernel_cyccb_blk_%d,\n", i);
			}
			else
			{
				fprintf(fp, "\t\tNULL,\n");
			}
		}
		fprintf(fp, "\t};\n");		
	}
#endif
#endif
	}

	// e[uTCYo
	fprintf(
		fp,
		"\nconst ID	_kernel_max_cycid = %d;\n",
		m_iMaxId);
}



void CApiCreCyc::WriteCyccbRam(FILE *fp, int iObj)
{
#if _KERNEL_CYCCB_TIMOBJ
	fprintf(fp, "{0}, ");														/* %jp{^CIuWFNg} */
#endif
}


void CApiCreCyc::WriteCyccbRom(FILE *fp, int iObj)
{
#if _KERNEL_CYCCB_CYCATR
	fprintf(fp, "(%s), ", m_pParamPacks[iObj]->GetParam(CRECYC_CYCATR));	/**< %jp{nh} */
#endif

#if _KERNEL_CYCCB_EXINF
	fprintf(fp, "(%s), ", m_pParamPacks[iObj]->GetParam(CRECYC_EXINF));		/**< %jp{nh̊g} */
#endif

#if _KERNEL_CYCCB_CYCHDR
	fprintf(fp, "(%s), ", m_pParamPacks[iObj]->GetParam(CRECYC_CYCHDR));	/**< %jp{nh} */
#endif

#if _KERNEL_CYCCB_CYCTIM
	fprintf(fp, "(%s), ", m_pParamPacks[iObj]->GetParam(CRECYC_CYCTIM));	/**< %jp{nh̋N} */
#endif

#if _KERNEL_CYCCB_CYCPHS
	fprintf(fp, "(%s), ", m_pParamPacks[iObj]->GetParam(CRECYC_CYCPHS));	/**< %jp{nh̋Nʑ} */
#endif
}



// cfgt@Co
void  CApiCreCyc::WriteCfgIni(FILE* fp)
{
#if _KERNEL_CYCCB_ALGORITHM == _KERNEL_CYCCB_ALG_PTRARRAY && _KERNEL_CYCCB_SPLIT_RO
	if ( m_iObjs <= 0 )
	{
		return;
	}

	fprintf(fp, "\n\t/* cycaphores */\n");
	for ( int i = 0; i < m_iObjs; i++ )
	{
		fprintf(fp, "\t_kernel_cyccb_blk_%d.cyccb_ro = &_kernel_cyccb_ro_blk_%d;\n", m_iId[i], m_iId[i]);
	}	
#endif
}


// cfgt@CNo
void  CApiCreCyc::WriteCfgStart(FILE* fp)
{
}


// end of file
