// ---------------------------------------------------------------------------
//  Hyper Operating System V4  RtBM[^[                           
//    CRE_DTQ API ̏                                                      
//                                                                            
//                                    Copyright (C) 1998-2003 by Project HOS  
//                                    http://sourceforge.jp/projects/hos/     
// ---------------------------------------------------------------------------


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "defercd.h"
#include "credtq.h"
#include "analyze.h"
#include "readcfg.h"



#define CREDTQ_DTQID		0
#define CREDTQ_DTQATR		1
#define CREDTQ_DTQCNT		2
#define CREDTQ_DTQ			3



// RXgN^
CApiCreDtq::CApiCreDtq()
{
	// %jp{ftHg̍őIDݒ}
	m_iDefaultMaxId = _KERNEL_DEF_TMAX_DTQID;
	
	// p[^[\ݒ
	m_iParamSyntax[0] = 0;		// Pƃp[^[
	m_iParamSyntax[1] = 3;		// 3p[^[̃ubN
	m_iParams         = 2;
}

// fXgN^
CApiCreDtq::~CApiCreDtq()
{
}


// APỈ
int CApiCreDtq::AnalyzeApi(const char* pszApiName, const char* pszParams)
{
	if ( strcmp(pszApiName, "CRE_DTQ") == 0 )
	{
		return AddParams(pszParams);
	}
	else if ( strcmp(pszApiName, "KERNEL_MAX_DTQID") == 0 )
	{
		int iId;

		if ( m_iMaxId > 0 )
		{
			return CFG_ERR_MULTIDEF;
		}

		if ( m_iResObj > 0 )
		{
			return CFG_ERR_DEF_CONFLICT;
		}

		if ( (iId = atoi(pszParams)) <= 0 )
		{
			return CFG_ERR_PARAM;
		}

		m_iMaxId = iId;

		return CFG_ERR_OK;
	}
	else if ( strcmp(pszApiName, "KERNEL_RSV_DTQID") == 0 )
	{
		int iId;

		if ( m_iMaxId > 0 )
		{
			return CFG_ERR_DEF_CONFLICT;
		}

		if ( (iId = atoi(pszParams)) < 0 )
		{
			return CFG_ERR_PARAM;
		}

		m_iResObj += iId;

		return CFG_ERR_OK;
	}
	
	return CFG_ERR_NOPROC;
}


// ID `t@Co
void CApiCreDtq::WriteId(FILE* fp)
{
	int i;

	if ( m_iMaxId <= 0 )
	{
		return;
	}

	// %jp{Rgo}
	fputs("\n\n/* Data queue object ID definetion */\n\n", fp);
	
	
	// %jp{ID`o}
	for ( i = 0; i < m_iObjs; i++ )
	{
		if ( atoi(m_pParamPacks[i]->GetParam(CREDTQ_DTQID)) == 0 )
		{
			fprintf(
				fp,
				"#define %s\t\t%d\n",
				m_pParamPacks[i]->GetParam(CREDTQ_DTQID),
				m_iId[i]);
		}
	}
	
	// %jp{IDől`o}
	fprintf( fp,
		"\n"
		"#ifdef  TMAX_DTQID\n"
		"#undef  TMAX_DTQID\n"
		"#endif\n"
		"\n"
		"#define TMAX_DTQID\t\t%d\n\n", m_iMaxId );

	// ID ڎwłȂIuWFNg݂邩ǂT[`
	for ( i = 0; i < m_iObjs; i++ )
	{
		if ( atoi(m_pParamPacks[i]->GetParam(CREDTQ_DTQID)) == 0 )
		{
			break;
		}
	}
	if ( i == m_iObjs )
	{
		return;
	}
}


// cfgt@C`o
void  CApiCreDtq::WriteCfgDef(FILE* fp)
{
	const char* pszParam;
	int  i;

	if ( m_iMaxId <= 0 )
	{
		return;
	}

	// %jp{Rgo}
	fputs(
		"\n\n\n"
		"/* ------------------------------------------ */\n"
		"/*        create data queue objects           */\n"
		"/* ------------------------------------------ */\n\n\n"
		, fp);


	// %jp{f[^L[̈o}
	for ( i = 0; i < m_iObjs; i++ )
	{
		pszParam = m_pParamPacks[i]->GetParam(CREDTQ_DTQ);
		if ( strcmp(pszParam, "NULL") == 0 )
		{
			pszParam = m_pParamPacks[i]->GetParam(CREDTQ_DTQCNT);
			if ( strcmp(pszParam, "0") != 0 )
			{
				fprintf(
					fp,
					"static VP_INT _kernel_dtq%d_dtq[(%s)];\n",
					m_iId[i],
					m_pParamPacks[i]->GetParam(CREDTQ_DTQCNT));
			}
		}
	}
	
	
	if ( m_iMaxId > 0 )
	{
#if _KERNEL_DTQCB_ALGORITHM == _KERNEL_DTQCB_ALG_BLKARRAY
#if _KERNEL_DTQCB_SPLIT_RO
	// %jp{ubNzROM}
	{
		// %jp{RAMo}
		fprintf(fp, "\n_KERNEL_T_DTQCB _kernel_dtqcb_tbl[%d] =\n\t{\n", m_iMaxId);
		for ( i = 1; i <= m_iMaxId; i++ )
		{
			int iObjNum = IdToObjNum(i);
			if ( iObjNum >= 0 )
			{
				fprintf(fp, "\t\t{");
				WriteDtqcbRam(fp, iObjNum);
				fprintf(fp, "},\n");
			}
			else
			{
				fprintf(fp, "\t\t{0},\n");
			}
		}
		fprintf(fp, "\t};\n");
		
		// %jp{ROMo}
		fprintf(fp, "\nconst _KERNEL_T_DTQCB_RO _kernel_dtqcb_ro_tbl[%d] =\n\t{\n", m_iMaxId);
		for ( i = 1; i <= m_iMaxId; i++ )
		{
			int iObjNum = IdToObjNum(i);
			if ( iObjNum >= 0 )
			{
				fprintf(fp, "\t\t{");
				WriteDtqcbRom(fp, iObjNum);
				fprintf(fp, "},\n");
			}
			else
			{
				fprintf(fp, "\t\t{0},\n");
			}
		}
		fprintf(fp, "\t};\n\n");
	}
#else
	// %jp{ubNz񁕓DTQCB}
	{
		// %jp{RAMo}
		fprintf(fp, "\n_KERNEL_T_DTQCB _kernel_dtqcb_tbl[%d] =\n\t{\n", m_iMaxId);
		for ( i = 1; i <= m_iMaxId; i++ )
		{
			int iObjNum = IdToObjNum(i);
			if ( iObjNum >= 0 )
			{
				fprintf(fp, "\t\t{");
				WriteDtqcbRam(fp, iObjNum);
				WriteDtqcbRom(fp, iObjNum);
				fprintf(fp, "},\n");
			}
			else
			{
				fprintf(fp, "\t\t{{0}, },\n");
			}
		}
		fprintf(fp, "\t};\n");
	}
#endif
#elif _KERNEL_DTQCB_ALGORITHM == _KERNEL_DTQCB_ALG_PTRARRAY
#if _KERNEL_DTQCB_SPLIT_RO
	// %jp{|C^zROM}
	{
		fprintf(fp, "\n");
		for ( i = 0; i < m_iObjs; i++ )
		{
			fprintf(fp, "const _KERNEL_T_DTQCB_RO _kernel_dtqcb_ro_blk_%d = {", m_iId[i]);
			WriteDtqcbRom(fp, i);
			fprintf(fp, "};\n");
		}
		fprintf(fp, "\n");
		for ( i = 0; i < m_iObjs; i++ )
		{
			fprintf(fp, "_KERNEL_T_DTQCB _kernel_dtqcb_blk_%d = {", m_iId[i]);
			WriteDtqcbRam(fp, i);
			fprintf(fp, "};\n");
		}
		fprintf(fp, "\n");
		fprintf(fp, "\n_KERNEL_T_DTQCB *_kernel_dtqcb_tbl[%d] =\n\t{\n", m_iMaxId);
		for ( i = 1; i <= m_iMaxId; i++ )
		{
			int iObjNum = IdToObjNum(i);
			if ( iObjNum >= 0 )
			{
				fprintf(fp, "\t\t&_kernel_dtqcb_blk_%d,\n", i);
			}
			else
			{
				fprintf(fp, "\t\tNULL,\n");
			}
		}
		fprintf(fp, "\t};\n");		
	}
#else
	// %jp{|C^z񁕓DTQCB}
	{
		fprintf(fp, "\n");
		for ( i = 0; i < m_iObjs; i++ )
		{
			fprintf(fp, "_KERNEL_T_DTQCB _kernel_dtqcb_blk_%d = {", m_iId[i]);
			WriteDtqcbRam(fp, i);
			WriteDtqcbRom(fp, i);
			fprintf(fp, "};\n");
		}
		fprintf(fp, "\n");
		fprintf(fp, "\n_KERNEL_T_DTQCB *_kernel_dtqcb_tbl[%d] =\n\t{\n", m_iMaxId);
		for ( i = 1; i <= m_iMaxId; i++ )
		{
			int iObjNum = IdToObjNum(i);
			if ( iObjNum >= 0 )
			{
				fprintf(fp, "\t\t&_kernel_dtqcb_blk_%d,\n", i);
			}
			else
			{
				fprintf(fp, "\t\tNULL,\n");
			}
		}
		fprintf(fp, "\t};\n");		
	}
#endif
#endif
	}

	// e[uTCYo
	fprintf(
		fp,
		"\nconst ID	_kernel_max_dtqid = %d;\n",
		m_iMaxId);
}


void CApiCreDtq::WriteDtqcbRam(FILE *fp, int iObj)
{
#if _KERNEL_DTQCB_SQUE
	fprintf(fp, "{0}, ");													/* %jp{f[^L[M҂^XNL[} */
#endif

#if _KERNEL_DTQCB_RQUE
	fprintf(fp, "{0}, ");													/* %jp{f[^L[M҂^XNL[} */
#endif

#if _KERNEL_DTQCB_SDTQCNT
	fprintf(fp, "0, ");														/* %jp{f[^L[ɓĂf[^̐}%en{The number of data elemnts int the data queue} */
#endif

#if _KERNEL_DTQCB_HEAD
	fprintf(fp, "0, ");														/* %jp{f[^L[̃f[^擪ʒu} */
#endif
}


void CApiCreDtq::WriteDtqcbRom(FILE *fp, int iObj)
{
#if _KERNEL_DTQCB_DTQATR
	fprintf(fp, "(%s), ", m_pParamPacks[iObj]->GetParam(CREDTQ_DTQATR));	/* %jp{f[^L[}%en{Data queue attribute} */
#endif

#if _KERNEL_DTQCB_DTQCNT
	fprintf(fp, "(%s), ", m_pParamPacks[iObj]->GetParam(CREDTQ_DTQCNT));	/* %jp{f[^L[̗̈e(f[^̌)}%en{Capacity of the data queue area(the number of data elements)} */
#endif

#if _KERNEL_DTQCB_DTQ		/* %jp{f[^L[̈̐擪Ԓn}%en{Start address of the data queue area} */
	if ( strcmp(m_pParamPacks[iObj]->GetParam(CREDTQ_DTQCNT), "0") == 0 )
	{
		fprintf(fp, "NULL, ");
	}
	else
	{
		if ( strcmp(m_pParamPacks[iObj]->GetParam(CREDTQ_DTQCNT), "NULL") == 0 )
		{
			fprintf(fp, "_kernel_dtq%d_dtq, ", m_iId[iObj]);
		}
		else
		{
			fprintf(fp, "(%s), ", m_pParamPacks[iObj]->GetParam(CREDTQ_DTQ));	
		}
	}
#endif
}



// cfgt@Co
void  CApiCreDtq::WriteCfgIni(FILE* fp)
{
	if ( m_iMaxId <= 0 )
	{
		return;
	}

	// IuWFNg݃`FbN
	if ( m_iObjs == 0 )
	{
		return;
	}
}


// cfgt@CNo
void  CApiCreDtq::WriteCfgStart(FILE* fp)
{
	// IuWFNg݃`FbN
	if ( m_iObjs == 0 )
	{
		return;
	}

	if ( m_iMaxId <= 0 )
	{
		return;
	}
}


// end of file
