// ---------------------------------------------------------------------------
//  Hyper Operating System V4  RtBM[^[                           
//    G[R[hǗ                                                        
//                                                                            
//                                    Copyright (C) 1998-2003 by Project HOS  
//                                    http://sourceforge.jp/projects/hos/     
// ---------------------------------------------------------------------------


#include "defercd.h"


static const char *szErrMsg[] =
	{
		"unanticipated EOF.",		// \EOF
		"illegal CR.",				// sȉs
		"status too long.",			// PXe[g
		"syntax error."	,			// \G[
		"expect \')\' but found.",	// ()̕s
		"expect \'}\' but found.",	// {}̕s
		"expect \';\' but found.",	// Z~R
		"illegal text.",			// sȕ萔
		"conflict ID.",				// IDՓ
		"illegal parameter.",		 // p[^[s
		"multiple definition.",		// BłׂAPI`
		"conflict definition.",		 // `Փ
	};


// G[擾
const char* GetErrMessage(int iErr)
{
	if ( iErr < 1 || iErr > (int)(sizeof(szErrMsg)/sizeof(char *)) )
	{
		return "unknown expression error.";
	}

	return szErrMsg[iErr - 1];
}


// ---------------------------------------------------------------------------
//  Copyright (C) 1998-2003 by Project HOS                                    
// ---------------------------------------------------------------------------
