// ---------------------------------------------------------------------------
//  Hyper Operating System V4  RtBM[^[                           
//    HOS_IDL_STK API ̏                                                  
//                                                                            
//                                    Copyright (C) 1998-2006 by Project HOS  
//                                    http://sourceforge.jp/projects/hos/     
// ---------------------------------------------------------------------------


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "defercd.h"
#include "idlstk.h"
#include "analyze.h"
#include "readcfg.h"


#define SYSSTK_STKSZ		0
#define SYSSTK_STK			1


// RXgN^
CApiIdleStack::CApiIdleStack()
{
	// p[^[\ݒ
	m_iParamSyntax[0] = 0;		// Pƃp[^[
	m_iParams = 2;
}


// fXgN^
CApiIdleStack::~CApiIdleStack()
{
}


// IDԍ蓖
int CApiIdleStack::AutoId(void)
{
	return CFG_ERR_OK;
}


// APỈ
int CApiIdleStack::AnalyzeApi(const char* pszApiName, const char* pszParams)
{
	if ( strcmp(pszApiName, "KERNEL_SYS_STK") == 0 )
	{
		if ( m_iObjs > 0 )
		{
			return CFG_ERR_MULTIDEF;
		}

		return AddParams(pszParams);
	}

	return CFG_ERR_NOPROC;
}


// cfgt@C`o
void  CApiIdleStack::WriteCfgDef(FILE* fp)
{
	const char* pszSize;
	const char* pszStack;

	// Rgo
	fputs(
		"\n\n\n"
		"/* ------------------------------------------ */\n"
		"/*               system stack                 */\n"
		"/* ------------------------------------------ */\n\n"
		, fp);

	// p[^ǂݏo
	if ( m_iObjs > 0 )
	{
		pszSize  = m_pParamPacks[0]->GetParam(SYSSTK_STKSZ);
		pszStack = m_pParamPacks[0]->GetParam(SYSSTK_STK);
	}
	else
	{
		pszSize  = "256";
		pszStack = "NULL";		// w肪NULL()
	}

	// ACh[vpX^bNo
	if ( strcmp(pszStack, "NULL") == 0 )
	{
		fprintf(
			fp,
			"VP         _kernel_sys_stkblk[((%s) + sizeof(VP) - 1) / sizeof(VP)];\t/* system stack block*/\n\n",
			pszSize);
	}
}


// cfgt@CNo
void  CApiIdleStack::WriteCfgIni(FILE* fp)
{
	const char* pszSize;
	const char* pszStack;

	// p[^ǂݏo
	if ( m_iObjs > 0 )
	{
		pszSize  = m_pParamPacks[0]->GetParam(SYSSTK_STKSZ);
		pszStack = m_pParamPacks[0]->GetParam(SYSSTK_STK);
	}
	else
	{
		pszSize  = "256";
		pszStack = "NULL";		// w肪NULL()
	}
	
	if ( strcmp(pszStack, "NULL") == 0 )
	{
		fprintf(
			fp,
			"\t_KERNEL_SYS_INI_SYSSTK((SIZE)sizeof(_kernel_sys_stkblk), (VP)(_kernel_sys_stkblk));\n");
	}
	else
	{
		fprintf(
			fp,
			"\t_KERNEL_SYS_INI_SYSSTK((SIZE)(%s), (VP)(%s));\n",
			pszSize, pszStack);
	}

}


// ---------------------------------------------------------------------------
//  Copyright (C) 1998-2003 by Project HOS                                    
// ---------------------------------------------------------------------------
