# ----------------------------------------------------------------------------
#  Hyper Operating System V4 Advance
#    common file for GNU make
#
#  Copyright (C) 1998-2008 by Project HOS
#  http://sourceforge.jp/projects/hos/
# ----------------------------------------------------------------------------



# --------------------------------------
#  %jp{IvV}%en{analyze option}
# --------------------------------------

ifeq ($(DEBUG),Yes)
# %jp{fobOw肪΃fobOō쐬}%en{debug mode}
TARGET := $(TARGET)dbg
C_DEFS += _DEBUG
A_DEFS += _DEBUG
AFLAGS += $(AFLAGS_DBG) $(AFLAGS_OPT_NONE)
CFLAGS += $(CFLAGS_DBG) $(CFLAGS_OPT_NONE)
else
ifeq ($(OPT_SPEED),Yes)
# %jp{xœKw肪ΑxD}%en{speed optimize}
AFLAGS += $(AFLAGS_OPT_SPEED)
CFLAGS += $(CFLAGS_OPT_SPEED)
else
ifeq ($(OPT_SIZE),Yes)
# %jp{TCYDKw肪΃TCYD}%en{size optimize}
AFLAGS += $(AFLAGS_OPT_SIZE)
CFLAGS += $(CFLAGS_OPT_SIZE)
else
# %jp{ftHgŒʏ̍œK}%en{default}
AFLAGS += $(AFLAGS_OPT_NORMAL)
CFLAGS += $(CFLAGS_OPT_NORMAL)
endif
endif
endif



# --------------------------------------
#  %jp{J[lCȗI}%en{select kernel library}
# --------------------------------------

KERNEL_LIB_NAME ?= libhosv4a
KERNEL_MAKOPT   ?=

# %jp{fobOw}%en{debug mode}
KERNEL_MAKOPT += DEBUG=$(KERNEL_DEBUG)
ifeq ($(KERNEL_DEBUG),Yes)
KERNEL_LIB_NAME := $(KERNEL_LIB_NAME)dbg
endif


# %jp{G[xw}%en{error check level}
KERNEL_MAKOPT += ERRLEVEL=$(KERNEL_ERRLEVEL)
ifeq ($(KERNEL_ERRLEVEL),0)
KERNEL_LIB_NAME := $(KERNEL_LIB_NAME)er0
endif
ifeq ($(KERNEL_ERRLEVEL),1)
KERNEL_LIB_NAME := $(KERNEL_LIB_NAME)er1
endif
ifeq ($(KERNEL_ERRLEVEL),2)
KERNEL_LIB_NAME := $(KERNEL_LIB_NAME)er2
endif
ifeq ($(KERNEL_ERRLEVEL),3)
KERNEL_LIB_NAME := $(KERNEL_LIB_NAME)er3
endif
ifeq ($(KERNEL_ERRLEVEL),4)
KERNEL_LIB_NAME := $(KERNEL_LIB_NAME)er4
endif


# %jp{J[ltbNw}%en{kernel hook}
KERNEL_MAKOPT += HOK_TSK=$(KERNEL_HOK_TSK)
ifeq ($(KERNEL_HOK_TSK),Yes)
KERNEL_LIB_NAME := $(KERNEL_LIB_NAME)tsk
endif
KERNEL_MAKOPT += HOK_INH=$(KERNEL_HOK_INH)
ifeq ($(KERNEL_HOK_INH),Yes)
KERNEL_LIB_NAME := $(KERNEL_LIB_NAME)inh
endif
KERNEL_MAKOPT += HOK_ISR=$(KERNEL_HOK_ISR)
ifeq ($(KERNEL_HOK_ISR),Yes)
KERNEL_LIB_NAME := $(KERNEL_LIB_NAME)isr
endif

# %jp{J[lCu}%en{kernel library}
KERNEL_LIB = $(KERNEL_BUILD_DIR)/$(KERNEL_LIB_NAME).$(EXT_LIB)



# --------------------------------------
#  %jp{J[lp̐ݒ}%en{add kernel setting}
# --------------------------------------

INC_DIRS += $(KERNEL_DIR)/include
LIBS     += $(KERNEL_LIB)



# --------------------------------------
#  %jp{eݒ}%en{other setting}
# --------------------------------------

# %jp{T[`pXݒ}
VPATH = $(subst $(space),:,$(SRC_DIRS))


# %jp{IuWFNgt@Co̓fBNg}
OBJS_DIR = objs_$(TARGET)


# %jp{IuWFNgt@C}
OBJS = $(addprefix $(OBJS_DIR)/, $(addsuffix .$(EXT_OBJ), $(basename $(notdir $(ASRCS)))))	\
       $(addprefix $(OBJS_DIR)/, $(addsuffix .$(EXT_OBJ), $(basename $(notdir $(CSRCS)))))



# end of file
