# ----------------------------------------------------------------------------
#  Hyper Operating System V4 Advance
#    common file for GNU make
#
#  Copyright (C) 1998-2008 by Project HOS
#  http://sourceforge.jp/projects/hos/
# ----------------------------------------------------------------------------



# --------------------------------------
#  %jp{[}%en{rule}
# --------------------------------------


# %jp{J[lCu}%en{kernel library}
$(KERNEL_LIB): kernel_make


# %jp{st@C}%en{make execution file}
.PHONY : makeexe_all
makeexe_all: $(KERNEL_LIB) makeexe_mkobjsdir $(CSRCS) $(ASRCS)


# %jp{N[ibv}%en{clean}
.PHONY : makeexe_clean
makeexe_clean:
	$(CMD_RM) -f $(TARGET_LIB) $(OBJS)


# %jp{IuWFNgo̓fBNg쐬}%en{make object file firectory}
.PHONY : makeexe_mkobjsdir
makeexe_mkobjsdir:
	$(CMD_MKDIR) -p $(OBJS_DIR)


# %jp{ˑ֌W̐}%en{make depend}
DEPFLAGS += -MM $(patsubst %,-I%,$(INC_DIRS))
.PHONY : makeexe_depend
makeexe_depend: makeexe_mkobjsdir
	$(CMD_DEPEND) $(DEPFLAGS) $(CSRCS) | sed -e 's?\.o?\.$(EXT_OBJ)?g' | sed -e 's?^\(.*\):?$(OBJS_DIR)/\1:?g' > $(OBJS_DIR)/depend.inc

-include $(OBJS_DIR)/depend.inc


# %jp{\[X̃Rs[}%en{sorce file copy}
ifneq ($(SRCCPYDIR),)
.PHONY : makeexe_srccpy
makeexe_srccpy:
	$(CMD_CP) -t $(SRCCPYDIR) $(ASRCS) $(CSRCS)
endif


# %jp{J[l}%en{make kernel library}
.PHONY : kernel_make
kernel_make:
	$(MAKE) -C $(KERNEL_BUILD_DIR) $(KERNEL_MAKOPT)


# %jp{J[lN[}%en{clean kernel}
.PHONY : kernel_clean
kernel_clean:
	$(MAKE) -C $(KERNEL_BUILD_DIR) $(KERNEL_MAKOPT) clean


# %jp{J[ldepend}%en{depend kernel}
.PHONY : kernel_depend
kernel_depend:
	$(MAKE) -C $(KERNEL_BUILD_DIR) $(KERNEL_MAKOPT) depend



# end of file
