/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  procatr.h
 * @brief %jp{vZbTA[LeN`ŗL@\}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef _KERNEL__arch__proc__h8__h8300ha__procatr_h__
#define _KERNEL__arch__proc__h8__h8300ha__procatr_h__


/* %jp{vZbTA[LeN``̂CN[hpX} */
#define _KERNEL_PROCATR_INC_PATH			"h8/h8300ha"


/* %jp{vZbTA[LeN`Ɉˑ} */
#define _KERNEL_PROCATR_CTX_STK				FALSE		/**< %jp{ReLXgɃX^bN̈̎w肪KvH} */
#define _KERNEL_PROCATR_CTX_STKSZ			FALSE		/**< %jp{ReLXgɃX^bNTCY̎w肪KvH} */
#define _KERNEL_PROCATR_CTX_ISP				TRUE		/**< %jp{ReLXgɏX^bN|C^lKvH} */
#define _KERNEL_PROCATR_CTX_DEL				FALSE		/**< %jp{ʃReLXg̃ReLXg폜KvH} */
#define _KERNEL_PROCATR_CTX_RST				TRUE		/**< %jp{ReLXg̃X^[g\H} */

#define _KERNEL_PROCATR_TMIN_STKSZ			(4*16)		/**< %jp{ŒKvȃX^bNTCY(byteP)} */

#define _KERNEL_PROCATR_SPT_SMP				FALSE		/**< %jp{SMPɑΉĂ邩H} */
#define _KERNEL_PROCATR_SPT_MULTINT			TRUE		/**< %jp{d݂ɑΉĂ邩H} */

#define _KERNEL_PROCATR_TMIN_INHNO			12			/**< %jp{݃nhԍ̍ŏl} */
#define _KERNEL_PROCATR_TMAX_INHNO			63			/**< %jp{݃nhԍ̍ől} */

#define _KERNEL_PROCATR_TMIN_EXCNO			7			/**< %jp{CPUOnhԍ̍ŏl} */
#define _KERNEL_PROCATR_TMAX_EXCNO			11			/**< %jp{CPUOnhԍ̍ől} */

#define _KERNEL_PROCATR_SYSSTK_NUM			1			/**< %jp{VXeX^bN͉{KvH} */

#define _KERNEL_PROCATR_SIGNED_INT			0			/**< %jp{tƕ̂ǂ炪ӂH(t:1, :-1, :0)} */
#define _KERNEL_PROCATR_HAS_MUL				TRUE		/**< %jp{Z߂LĂ邩H} */
#define _KERNEL_PROCATR_HAS_HW_MUL			FALSE		/**< %jp{n[hEFAZLĂ邩H} */
#define _KERNEL_PROCATR_HAS_DIV				TRUE		/**< %jp{Z߂LĂ邩H} */
#define _KERNEL_PROCATR_HAS_HW_DIV			FALSE		/**< %jp{n[hEFAZLĂ邩H} */
#define _KERNEL_PROCATR_HAS_BSC				FALSE		/**< %jp{rbgXL߂LĂ邩H} */
#define _KERNEL_PROCATR_HAS_SHIFT			FALSE		/**< %jp{Cbit̃Vtg߂LĂ邩H} */
#define _KERNEL_PROCATR_HAS_HW_SHIFTER		FALSE		/**< %jp{oVt^LĂ邩H} */

#define _KERNEL_PROCATR_TBIT_INT			16			/**< %jp{vZbTɍœKȐ^̃rbg} */
#define _KERNEL_PROCATR_TBIT_PTR			32			/**< %jp{|C^^̃rbg} */
#define _KERNEL_PROCATR_TBIT_DATAPTR		24			/**< %jp{f[^pAhXɕKvȗLrbg} */
#define _KERNEL_PROCATR_TBIT_FUNCPTR		24			/**< %jp{֐pAhXɕKvȗLrbg} */
#define _KERNEL_PROCATR_MEM_ALIGN			8			/**< %jp{K؂ȃ̃ACg(byteP)} */
#define _KERNEL_PROCATR_STK_ALIGN			8			/**< %jp{K؂ȃX^bÑACg(byteP)} */
#define _KERNEL_PROCATR_INST_ALIGN			1			/**< %jp{CXgNṼACg} */
#define _KERNEL_PROCATR_ALLOW_UNALIGN		TRUE		/**< %jp{f[^̃AACANZX͉\H} */
#define _KERNEL_PROCATR_ALLOW_INST_UNALIGN	TRUE		/**< %jp{߂̃AACzu͉\H} */


#endif	/* _KERNEL__arch__proc__h8__h8300ha__procatr_h__ */


/* end of file */
