/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  procatr.h
 * @brief %jp{vZbTA[LeN`ŗL`(SH2 processor)}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef _KERNEL__arch__proc__sh__sh2__procatr_h__
#define _KERNEL__arch__proc__sh__sh2__procatr_h__


/* %jp{vZbTA[LeN``̂CN[hpX} */
#define _KERNEL_PROCATR_INC_PATH			"sh/sh2"


/* %jp{vZbTA[LeN`Ɉˑ} */
#define _KERNEL_PROCATR_CTX_STK				FALSE		/**< %jp{ReLXgɃX^bN̈̎w肪KvH} */
#define _KERNEL_PROCATR_CTX_STKSZ			FALSE		/**< %jp{ReLXgɃX^bNTCY̎w肪KvH} */
#define _KERNEL_PROCATR_CTX_ISP				TRUE		/**< %jp{ReLXgɏX^bN|C^lKvH} */
#define _KERNEL_PROCATR_CTX_DEL				FALSE		/**< %jp{ʃReLXg̃ReLXg폜KvH} */
#define _KERNEL_PROCATR_CTX_RST				TRUE		/**< %jp{ReLXg̃X^[g\H} */

#define _KERNEL_PROCATR_TMIN_STKSZ			(4*16)		/**< %jp{ŒKvȃX^bNTCY(byteP)} */

#define _KERNEL_PROCATR_SPT_SMP				FALSE		/**< %jp{SMPɑΉĂ邩H} */
#define _KERNEL_PROCATR_SPT_MULTINT			TRUE		/**< %jp{d݂ɑΉĂ邩H} */

#define _KERNEL_PROCATR_TMIN_INHNO			64			/**< %jp{݃nhԍ̍ŏl} */
#define _KERNEL_PROCATR_TMAX_INHNO			255			/**< %jp{݃nhԍ̍ől} */

#define _KERNEL_PROCATR_TMIN_EXCNO			4			/**< %jp{CPUOnhԍ̍ŏl} */
#define _KERNEL_PROCATR_TMAX_EXCNO			63			/**< %jp{CPUOnhԍ̍ől} */

#define _KERNEL_PROCATR_EXCSTK_NUM			0			/**< %jp{CPUOpX^bN͉{KvH} */
#define _KERNEL_PROCATR_INTSTK_NUM			1			/**< %jp{݃X^bN͉{KvH} */

#define _KERNEL_PROCATR_SIGNED_INT			0			/**< %jp{tƕ̂ǂ炪ӂH(t:1, :-1, :0)} */
#define _KERNEL_PROCATR_TBIT_INT			32			/**< %jp{vZbTɍœKȐ^̃rbg} */
#define _KERNEL_PROCATR_TBIT_PTR			32			/**< %jp{|C^̃rbg} */
#define _KERNEL_PROCATR_MEM_ALIGN			8			/**< %jp{K؂ȃ̃ACg(byteP)} */
#define _KERNEL_PROCATR_STK_ALIGN			4			/**< %jp{K؂ȃX^bÑACg(byteP)} */
#define _KERNEL_PROCATR_ALLOW_UNALIGN		FALSE		/**< %jp{AACANZX͉\H} */


#endif	/* _KERNEL__arch__proc__sh__sh2__procatr_h__ */


/* end of file */
