/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  cmpl.h
 * @brief %jp{RpCwb_t@C}%en{uITRON4.0 kernel type header file}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef _KERNEL__core__cmpl_h__
#define _KERNEL__core__cmpl_h__

#if !defined(__STDC_VERSION__)
#define __STDC_VERSION__	0
#endif

#if __STDC_VERSION__ >= 199901L && !defined(SDCC)

/* C99(ISO/IEC 9899:1999) */
#define _KERNEL_CMPL_STDINT_H			TRUE						/**< %jp{stdint.h͗p\H} */

#elif defined(__GNUC__) && !defined(__STRICT_ANSI__)

/* gcc */
#if defined(__LONG_LONG_MAX__)

#define _KERNEL_CMPL_STDINT_H			FALSE						/**< %jp{stdint.h͗p\H} */
#define _KERNEL_CMPL_64BIT				TRUE						/**< %jp{64rbg͗p\H} */
#define _KERNEL_CMPL_INT64				long long					/**< %jp{t64rbg̐錾} */
#define _KERNEL_CMPL_UINT64				unsigned long long			/**< %jp{64rbg̐錾} */
#define _KERNEL_CMPL_CONSTNAT_INT64(x)	(x ## LL)					/**< %jp{t64rbg̒萔} */
#define _KERNEL_CMPL_CONSTNAT_UINT64(x)	(x ## ULL)					/**< %jp{64rbg̒萔} */
#define _KERNEL_CMPL_TMIN_INT64			(-__LONG_LONG_MAX__-1)		/**< %jp{t64rbg̍ŏl} */
#define _KERNEL_CMPL_TMAX_INT64			__LONG_LONG_MAX__ 			/**< %jp{t64rbg̍ől} */
#define _KERNEL_CMPL_TMIN_UINT64		(0ULL)						/**< %jp{64rbg̍ŏl} */
#define _KERNEL_CMPL_TMAX_UINT64		(__LONG_LONG_MAX__*2ULL+1)	/**< %jp{64rbg̍ől} */
#define _KERNEL_CMPL_PTR_SIZE			32							/**< %jp{|C^TCY`邩H} */

#endif

#elif defined(_MSC_VER)

/* Visual-C++ */
#define _KERNEL_CMPL_STDINT_H			FALSE						/**< %jp{stdint.h͗p\H} */

#define _KERNEL_CMPL_64BIT				TRUE						/**< %jp{64rbg͗p\H} */
#define _KERNEL_CMPL_INT64				signed __int64				/**< %jp{t64rbg̐錾} */
#define _KERNEL_CMPL_UINT64				unsigned __int64			/**< %jp{64rbg̐錾} */
#define _KERNEL_CMPL_CONSTNAT_INT64(x)	(x)							/**< %jp{t64rbg̒萔} */
#define _KERNEL_CMPL_CONSTNAT_UINT64(x)	(x)							/**< %jp{64rbg̒萔} */
#define _KERNEL_CMPL_TMIN_INT64			(-9223372036854775808)		/**< %jp{t64rbg̍ŏl} */
#define _KERNEL_CMPL_TMAX_INT64			9223372036854775807			/**< %jp{t64rbg̍ől} */
#define _KERNEL_CMPL_TMIN_UINT64		0							/**< %jp{64rbg̍ŏl} */
#define _KERNEL_CMPL_TMAX_UINT64		18446744073709551615		/**< %jp{64rbg̍ől} */
#define _KERNEL_CMPL_PTR_SIZE			32							/**< %jp{|C^TCY`邩H} */


#elif defined(__ARMCC_VERSION) && !defined(__STRICT_ANSI__)

/* armcc */
#define _KERNEL_CMPL_STDINT_H			TRUE						/**< %jp{stdint.h͗p\H} */

#else

/* ANSI-C (ISO/IEC 9899:1990) standard compiler */
#define _KERNEL_CMPL_STDINT_H			FALSE						/**< %jp{stdint.h͗p\H} */
#define _KERNEL_CMPL_64BIT				FALSE						/**< %jp{64rbg͗p\H} */

#endif


#endif	/* _KERNEL__core__cmpl_h__ */


/* end of file */
